/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.x86.platform;

import com.google.inject.Inject;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.mita.program.generator.IPlatformTimeGenerator;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TimeGenerator
implements IPlatformTimeGenerator {
    @Inject
    @Extension
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected IPlatformEventLoopGenerator eventLoopGenerator;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;

    public CodeFragment generateTimeEnable(CompilationContext context, EventHandlerDeclaration handler) {
        EventSource _event = handler.getEvent();
        final int period = ModelUtils.getIntervalInMilliseconds((TimeIntervalEvent)((TimeIntervalEvent)_event));
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"lastTick");
                String _firstUpper = StringExtensions.toFirstUpper((String)Integer.valueOf(period).toString());
                _builder.append((Object)_firstUpper);
                _builder.append((Object)" = getTime();");
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#ifdef __linux__");
                _builder.newLine();
                _builder.append((Object)"#include <unistd.h>");
                _builder.newLine();
                _builder.append((Object)"#include <time.h>");
                _builder.newLine();
                _builder.append((Object)"#include <bits/time.h>");
                _builder.newLine();
                _builder.append((Object)"void sleepMs(uint32_t ms) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"usleep(ms * 1000);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"int32_t getTime(void) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"struct timespec ts;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"clock_gettime(CLOCK_MONOTONIC, &ts);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return 1000*ts.tv_sec + ts.tv_nsec/1000000; ");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"#endif");
                _builder.newLine();
                _builder.append((Object)"#ifdef _WIN32");
                _builder.newLine();
                _builder.append((Object)"#include <windows.h>");
                _builder.newLine();
                _builder.append((Object)"void sleepMs(uint32_t ms) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"Sleep(ms);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"int32_t getTime() {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"clock();");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"#endif");
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1).addHeader("time.h", true).addHeader("MitaExceptions.h", false).addHeader("MitaEvents.h", false);
    }

    public CodeFragment generateTimeGoLive(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateTimeSetup(CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return 0;");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateAdditionalHeaderContent(CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#ifdef __linux__");
                _builder.newLine();
                _builder.append((Object)"#include <unistd.h>");
                _builder.newLine();
                _builder.append((Object)"#include <time.h>");
                _builder.newLine();
                _builder.append((Object)"#include <bits/time.h>");
                _builder.newLine();
                _builder.append((Object)"void sleepMs(uint32_t ms);");
                _builder.newLine();
                _builder.append((Object)"int32_t getTime(void);");
                _builder.newLine();
                _builder.append((Object)"#endif");
                _builder.newLine();
                _builder.append((Object)"#ifdef _WIN32");
                _builder.newLine();
                _builder.append((Object)"#include <windows.h>");
                _builder.newLine();
                _builder.append((Object)"void sleepMs(uint32_t ms);");
                _builder.newLine();
                _builder.append((Object)"int32_t getTime();");
                _builder.newLine();
                _builder.append((Object)"#endif");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }
}

