/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.cli.commands;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mita.base.scoping.ILibraryProvider;
import org.eclipse.mita.cli.commands.AbstractCommand;
import org.eclipse.mita.cli.commands.CompileToCAdapter;
import org.eclipse.mita.cli.loader.StandaloneLibraryProvider;
import org.eclipse.mita.program.generator.internal.IGeneratorOnResourceSet;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CompileCommand
extends AbstractCommand {
    @Inject
    protected XtextResourceSet resourceSet;
    @Inject
    protected ILibraryProvider libraryProvider;
    @Inject
    protected Provider<JavaIoFileSystemAccess> fileSystemAccessProvider;
    @Inject
    protected IGenerator2 generator;
    @Inject
    protected IResourceValidator resourceValidator;
    protected String projectPath;

    @Override
    public Options getOptions() {
        Options result = new Options();
        Option projectPathOption = new Option("p", "project-path", true, "Path to the Mita project");
        projectPathOption.setRequired(true);
        result.addOption(projectPathOption);
        result.addOption("o", "output", true, "Directory where to generate the output");
        return result;
    }

    @Override
    public boolean init(String commandName, CommandLine commandLine) {
        super.init(commandName, commandLine);
        this.projectPath = commandLine.getOptionValue("project-path");
        return true;
    }

    protected void loadResourceSet() {
        try {
            if (this.libraryProvider instanceof StandaloneLibraryProvider) {
                ((StandaloneLibraryProvider)this.libraryProvider).init((ResourceSet)this.resourceSet);
            }
            this.resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
            List allFilesInClasspath = IterableExtensions.toList(CompileCommand.getAllMitaAndPlatformFilesInClasspath());
            for (String libraryFile : allFilesInClasspath) {
                InputOutput.println((Object)("Loading " + libraryFile));
                this.resourceSet.getResource(URI.createURI((String)libraryFile), true);
            }
            EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
            Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

                public Boolean apply(Resource it) {
                    return it.getURI().toString().endsWith(".platform");
                }
            };
            this.validateResources(IterableExtensions.filter((Iterable)this.resourceSet.getResources(), (Functions.Function1)_function));
            BiPredicate<Path, BasicFileAttributes> _function_1 = new BiPredicate<Path, BasicFileAttributes>(){

                @Override
                public boolean test(Path filePath, BasicFileAttributes fileAttr) {
                    return fileAttr.isRegularFile();
                }
            };
            Predicate<Path> _function_2 = new Predicate<Path>(){

                @Override
                public boolean test(Path x) {
                    return x.toString().endsWith(".mita");
                }
            };
            Consumer<Path> _function_3 = new Consumer<Path>(){

                @Override
                public void accept(Path x) {
                    URI fileUri = URI.createFileURI((String)x.toFile().toString());
                    Resource resource = CompileCommand.this.resourceSet.getResource(fileUri, true);
                    EList _eAdapters = resource.eAdapters();
                    CompileToCAdapter _compileToCAdapter = new CompileToCAdapter();
                    _eAdapters.add((Object)_compileToCAdapter);
                }
            };
            Files.find(Paths.get(this.projectPath, new String[0]), Integer.MAX_VALUE, _function_1, new FileVisitOption[0]).filter(_function_2).forEach(_function_3);
            EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void validateResources(Iterable<Resource> resources) {
        try {
            Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

                public Boolean apply(Resource resource) {
                    boolean _not;
                    List issues = CompileCommand.this.resourceValidator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
                    boolean _isEmpty = issues.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        Consumer<Issue> _function = new Consumer<Issue>(){

                            @Override
                            public void accept(Issue it) {
                                System.err.println(it);
                            }
                        };
                        issues.forEach(_function);
                        return true;
                    }
                    return false;
                }
            };
            Functions.Function1<Boolean, Boolean> _function_1 = new Functions.Function1<Boolean, Boolean>(){

                public Boolean apply(Boolean it) {
                    return it;
                }
            };
            boolean hasIssues = IterableExtensions.exists((Iterable)IterableExtensions.map(resources, (Functions.Function1)_function), (Functions.Function1)_function_1);
            if (hasIssues) {
                throw new Exception("Errors found in the code. See above.");
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Iterable<String> getAllMitaAndPlatformFilesInClasspath() {
        Iterable _xblockexpression = null;
        LinkedList rootURLs = new LinkedList();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                CollectionExtensions.addAll(rootURLs, (Object[])((URLClassLoader)cl).getURLs());
            }
            cl = cl.getParent();
        }
        Functions.Function1<URL, Iterable<String>> _function = new Functions.Function1<URL, Iterable<String>>(){

            public Iterable<String> apply(URL it) {
                Iterable<String> _xblockexpression = null;
                String _path = it.getPath();
                File file = new File(_path);
                Iterable<String> _xifexpression = null;
                boolean _isDirectory = file.isDirectory();
                _xifexpression = _isDirectory ? CompileCommand.listChildren(file) : CompileCommand.listChildren(it);
                _xblockexpression = _xifexpression;
                return _xblockexpression;
            }
        };
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return it.endsWith(".mita") || it.endsWith(".platform");
            }
        };
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.replace("classpath://", "classpath:/");
            }
        };
        _xblockexpression = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap(rootURLs, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    protected static Iterable<String> listChildren(File f) {
        List _xifexpression = null;
        boolean _isDirectory = f.isDirectory();
        if (_isDirectory) {
            Functions.Function1<File, Iterable<String>> _function = new Functions.Function1<File, Iterable<String>>(){

                public Iterable<String> apply(File it) {
                    return CompileCommand.listChildren(it);
                }
            };
            _xifexpression = IterableExtensions.flatMap((Iterable)((Iterable)Conversions.doWrapArray((Object)f.listFiles())), (Functions.Function1)_function);
        } else {
            String _absolutePath = f.getAbsolutePath();
            String _plus = "file://" + _absolutePath;
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_plus}));
        }
        return _xifexpression;
    }

    protected static Iterable<String> listChildren(URL url) {
        try {
            LinkedList<String> result = new LinkedList<String>();
            InputStream urlIn = url.openStream();
            final JarInputStream jarIn = new JarInputStream(urlIn);
            JarEntry entry = new Functions.Function0<JarEntry>(){

                public JarEntry apply() {
                    try {
                        return jarIn.getNextJarEntry();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            while (entry != null) {
                String _name = entry.getName();
                String _plus = "classpath://" + _name;
                result.add(_plus);
                entry = jarIn.getNextJarEntry();
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Iterable<Resource> getProjectResources() {
        Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

            public Boolean apply(Resource it) {
                Functions.Function1<Adapter, Boolean> _function = new Functions.Function1<Adapter, Boolean>(){

                    public Boolean apply(Adapter it) {
                        return it instanceof CompileToCAdapter;
                    }
                };
                return IterableExtensions.exists((Iterable)it.eAdapters(), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.filter((Iterable)this.resourceSet.getResources(), (Functions.Function1)_function);
    }

    @Override
    public void run() {
        this.loadResourceSet();
        boolean _isEmpty = this.resourceSet.getResources().isEmpty();
        if (_isEmpty) {
            System.err.println("Project " + this.projectPath + " is empty. Aborting");
            return;
        }
        final JavaIoFileSystemAccess fileSystemAccess = (JavaIoFileSystemAccess)this.fileSystemAccessProvider.get();
        String _elvis = null;
        String _optionValue = this.commandLine.getOptionValue("o");
        _elvis = _optionValue != null ? _optionValue : String.valueOf(this.projectPath) + "/src-gen/";
        fileSystemAccess.setOutputPath(_elvis);
        if (this.generator instanceof IGeneratorOnResourceSet) {
            Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

                public Boolean apply(Resource it) {
                    Functions.Function1<Adapter, Boolean> _function = new Functions.Function1<Adapter, Boolean>(){

                        public Boolean apply(Adapter it) {
                            return it instanceof CompileToCAdapter;
                        }
                    };
                    return IterableExtensions.exists((Iterable)it.eAdapters(), (Functions.Function1)_function);
                }
            };
            ((IGeneratorOnResourceSet)this.generator).doGenerate((ResourceSet)this.resourceSet, (IFileSystemAccess2)fileSystemAccess, (Functions.Function1)_function);
        } else {
            GeneratorContext _generatorContext = new GeneratorContext();
            Procedures.Procedure1<GeneratorContext> _function_1 = new Procedures.Procedure1<GeneratorContext>(){

                public void apply(GeneratorContext it) {
                    it.setCancelIndicator(CancelIndicator.NullImpl);
                }
            };
            final GeneratorContext generatorContext = (GeneratorContext)ObjectExtensions.operator_doubleArrow((Object)_generatorContext, (Procedures.Procedure1)_function_1);
            Consumer<Resource> _function_2 = new Consumer<Resource>(){

                @Override
                public void accept(Resource it) {
                    CompileCommand.this.generator.doGenerate(it, (IFileSystemAccess2)fileSystemAccess, (IGeneratorContext)generatorContext);
                }
            };
            this.getProjectResources().forEach(_function_2);
        }
    }
}

