/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.expressions.inferrer;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.GenericElement;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.PrimitiveType;
import org.eclipse.mita.base.types.Property;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeParameter;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.base.types.validation.TypeValidator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeParameterInferrer {
    @Inject
    private ITypeSystem registry;
    @Inject
    private TypeValidator typeValidator;

    public void inferTypeParametersFromOperationArguments(List<Parameter> parameters, List<ITypeSystemInferrer.InferenceResult> arguments, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, final IValidationIssueAcceptor acceptor) {
        int _size_1;
        boolean _lessEqualsThan;
        int _size = parameters.size();
        boolean bl = _lessEqualsThan = _size <= (_size_1 = arguments.size());
        if (_lessEqualsThan) {
            int i = 0;
            while (i < parameters.size()) {
                TypeSpecifier parameter = parameters.get(i).getTypeSpecifier();
                ITypeSystemInferrer.InferenceResult argument = arguments.get(i);
                boolean _parameterContainsTypeParameter = this.parameterContainsTypeParameter(parameter);
                if (_parameterContainsTypeParameter) {
                    final IValidationIssueAcceptor.ListBasedValidationIssueAcceptor thisIssueAcceptor = this.createIssueAcceptor();
                    IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

                        @Override
                        public void accept(IValidationIssueAcceptor.ValidationIssue it) {
                            thisIssueAcceptor.accept(it);
                            acceptor.accept(it);
                        }
                    };
                    this.assertArgumentAndParameterSoftCompatible(argument, parameter, _function);
                    boolean _isEmpty = thisIssueAcceptor.getTraces().isEmpty();
                    if (_isEmpty) {
                        this.inferTypeParameterFromOperationArgument(parameter, argument, inferredTypeParameterTypes, acceptor);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean parameterContainsTypeParameter(TypeSpecifier specifier) {
        Type type;
        Type _type = null;
        if (specifier != null) {
            _type = specifier.getType();
        }
        if ((type = _type) instanceof PrimitiveType) {
            return false;
        }
        if (type instanceof TypeParameter) {
            return true;
        }
        if (type instanceof ComplexType) {
            boolean _tripleNotEquals;
            EList _typeParameters = ((ComplexType)type).getTypeParameters();
            boolean bl = _tripleNotEquals = _typeParameters != null;
            if (_tripleNotEquals) {
                return true;
            }
            Iterable _filter = Iterables.filter(((ComplexType)type).getFeatures(), Property.class);
            for (Property prop : _filter) {
                boolean _parameterContainsTypeParameter = this.parameterContainsTypeParameter(prop.getTypeSpecifier());
                if (!_parameterContainsTypeParameter) continue;
                return true;
            }
        }
        return false;
    }

    protected void inferTypeParameterFromOperationArgument(TypeSpecifier parameterTypeSpecifier, ITypeSystemInferrer.InferenceResult argumentType, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        Type parameterType;
        Type _type = null;
        if (parameterTypeSpecifier != null) {
            _type = parameterTypeSpecifier.getType();
        }
        if ((parameterType = _type) instanceof TypeParameter) {
            this.doInferTypeParameterFromOperationArgument((TypeParameter)parameterType, argumentType, inferredTypeParameterTypes, acceptor);
        } else if (parameterType instanceof GenericElement) {
            this.doInferGenericTypeFromOperationArgument(parameterTypeSpecifier, argumentType, inferredTypeParameterTypes, acceptor);
        }
    }

    protected void doInferGenericTypeFromOperationArgument(TypeSpecifier parameterTypeSpecifier, ITypeSystemInferrer.InferenceResult argumentType, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        int i = 0;
        while (i < parameterTypeSpecifier.getTypeArguments().size()) {
            boolean _lessEqualsThan;
            TypeSpecifier typeParameter = (TypeSpecifier)parameterTypeSpecifier.getTypeArguments().get(i);
            int _size = argumentType.getBindings().size();
            boolean bl = _lessEqualsThan = _size <= i;
            if (_lessEqualsThan) {
                this.error(acceptor, typeParameter, "NotInferrableTypeParameter");
            } else {
                ITypeSystemInferrer.InferenceResult typeArgument = argumentType.getBindings().get(i);
                this.inferTypeParameterFromOperationArgument(typeParameter, typeArgument, inferredTypeParameterTypes, acceptor);
            }
            ++i;
        }
    }

    protected ITypeSystemInferrer.InferenceResult doInferTypeParameterFromOperationArgument(TypeParameter typeParameter, ITypeSystemInferrer.InferenceResult argumentType, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, final IValidationIssueAcceptor acceptor) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        Type newMappedType = argumentType.getType();
        ITypeSystemInferrer.InferenceResult typeInMap = inferredTypeParameterTypes.get(typeParameter);
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        if (typeInMap == null) {
            _xifexpression = inferredTypeParameterTypes.put(typeParameter, ITypeSystemInferrer.InferenceResult.from(newMappedType, argumentType.getBindings()));
        } else {
            ITypeSystemInferrer.InferenceResult _xblockexpression_1 = null;
            Type commonType = this.getCommonType(argumentType, typeInMap);
            String errorMsg = String.format("Incompatible types %s and %s.", argumentType.toString(), typeInMap.toString());
            final IValidationIssueAcceptor.ListBasedValidationIssueAcceptor thisIssueAcceptor = this.createIssueAcceptor();
            IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

                @Override
                public void accept(IValidationIssueAcceptor.ValidationIssue it) {
                    thisIssueAcceptor.accept(it);
                    acceptor.accept(it);
                }
            };
            this.typeValidator.assertTypeBindingsSame(argumentType, typeInMap, errorMsg, _function);
            ITypeSystemInferrer.InferenceResult _xifexpression_1 = null;
            if (commonType == null || !thisIssueAcceptor.getTraces().isEmpty()) {
                inferredTypeParameterTypes.put(typeParameter, null);
                this.error(acceptor, String.format("Could not infer common type for type parameter %s from argument types %s.", typeParameter.getName(), CollectionLiterals.newArrayList((Object[])new String[]{argumentType.getType().getName(), typeInMap.getType().getName()})), "NotInferrableTypeParameter");
            } else {
                _xifexpression_1 = inferredTypeParameterTypes.put(typeParameter, ITypeSystemInferrer.InferenceResult.from(commonType, argumentType.getBindings()));
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Type getCommonType(ITypeSystemInferrer.InferenceResult type1, ITypeSystemInferrer.InferenceResult type2) {
        return this.registry.getCommonType(type1.getType(), type2.getType());
    }

    protected ITypeSystemInferrer.InferenceResult buildInferenceResult(ITypeSystemInferrer.InferenceResult oldInferenceResult, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        Type oldInferredType = oldInferenceResult.getType();
        if (oldInferredType instanceof TypeParameter) {
            ITypeSystemInferrer.InferenceResult mappedType = inferredTypeParameterTypes.get(oldInferredType);
            if (mappedType == null) {
                this.warning(acceptor, (TypeParameter)oldInferredType, "NotInferrableTypeParameter");
                return null;
            }
            return mappedType;
        }
        if (oldInferredType instanceof GenericElement) {
            ArrayList newBindings = CollectionLiterals.newArrayList();
            List<ITypeSystemInferrer.InferenceResult> _bindings = oldInferenceResult.getBindings();
            for (ITypeSystemInferrer.InferenceResult oldBinding : _bindings) {
                newBindings.add(this.buildInferenceResult(oldBinding, inferredTypeParameterTypes, acceptor));
            }
            return ITypeSystemInferrer.InferenceResult.from(oldInferenceResult.getType(), newBindings);
        }
        return oldInferenceResult;
    }

    public void inferTypeParametersFromOwner(ITypeSystemInferrer.InferenceResult operationOwnerResult, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes) {
        Type operationOwnerType;
        Type _type = null;
        if (operationOwnerResult != null) {
            _type = operationOwnerResult.getType();
        }
        if ((operationOwnerType = _type) instanceof GenericElement) {
            int i = 0;
            while (i < ((GenericElement)((Object)operationOwnerType)).getTypeParameters().size() && i < operationOwnerResult.getBindings().size()) {
                TypeParameter typeParameter = (TypeParameter)((GenericElement)((Object)operationOwnerType)).getTypeParameters().get(i);
                ITypeSystemInferrer.InferenceResult binding = operationOwnerResult.getBindings().get(i);
                inferredTypeParameterTypes.put(typeParameter, binding);
                ++i;
            }
        }
    }

    protected void assertArgumentAndParameterSoftCompatible(ITypeSystemInferrer.InferenceResult argumentResult, TypeSpecifier parameter, final IValidationIssueAcceptor acceptor) {
        Type _type = null;
        if (parameter != null) {
            _type = parameter.getType();
        }
        if (_type instanceof TypeParameter) {
            return;
        }
        ITypeSystemInferrer.InferenceResult result1 = ITypeSystemInferrer.InferenceResult.from(argumentResult.getType());
        ITypeSystemInferrer.InferenceResult result2 = ITypeSystemInferrer.InferenceResult.from(parameter.getType());
        final IValidationIssueAcceptor.ListBasedValidationIssueAcceptor thisIssueAcceptor = this.createIssueAcceptor();
        IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

            @Override
            public void accept(IValidationIssueAcceptor.ValidationIssue it) {
                thisIssueAcceptor.accept(it);
                acceptor.accept(it);
            }
        };
        this.typeValidator.assertCompatible(result1, result2, null, _function);
        if (thisIssueAcceptor.getTraces().isEmpty() && parameter.getTypeArguments() != null && parameter.getTypeArguments().size() != argumentResult.getBindings().size()) {
            Functions.Function1<TypeSpecifier, ITypeSystemInferrer.InferenceResult> _function_1 = new Functions.Function1<TypeSpecifier, ITypeSystemInferrer.InferenceResult>(){

                public ITypeSystemInferrer.InferenceResult apply(TypeSpecifier it) {
                    return ITypeSystemInferrer.InferenceResult.from(it.getType());
                }
            };
            List bindings = ListExtensions.map(parameter.getTypeArguments(), (Functions.Function1)_function_1);
            this.error(acceptor, String.format("Incompatible types %s and %s.", argumentResult, ITypeSystemInferrer.InferenceResult.from(parameter.getType(), bindings)), "IncompatibleTypes");
        }
    }

    protected IValidationIssueAcceptor.ListBasedValidationIssueAcceptor createIssueAcceptor() {
        return new IValidationIssueAcceptor.ListBasedValidationIssueAcceptor();
    }

    protected void error(IValidationIssueAcceptor acceptor, String msg, String issueCode) {
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void error(IValidationIssueAcceptor acceptor, TypeSpecifier typeSpecifier, String issueCode) {
        String _format = String.format("Could not infer type for type parameter %s.", typeSpecifier.getType().getName());
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, _format, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void error(IValidationIssueAcceptor acceptor, TypeParameter typeParameter, String issueCode) {
        String _format = String.format("Could not infer type for type parameter %s.", typeParameter.getName());
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, _format, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void warning(IValidationIssueAcceptor acceptor, String msg, String issueCode) {
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.WARNING, msg, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void warning(IValidationIssueAcceptor acceptor, TypeParameter typeParameter, String issueCode) {
        String _format = String.format("Could not infer type for type parameter %s.", typeParameter.getName());
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.WARNING, _format, issueCode);
        acceptor.accept(_validationIssue);
    }
}

