/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.expressions.scoping;

import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;

public abstract class AbstractLibraryGlobalScopeProvider
extends AbstractGlobalScopeProvider
implements IGlobalScopeProvider {
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    private Cache<URI, Iterable<IEObjectDescription>> libraryCache = CacheBuilder.newBuilder().build();

    protected abstract Set<URI> getLibraries(Resource var1);

    protected Iterable<URI> getValidLibraries(Resource context) {
        return Iterables.filter(this.getLibraries(context), (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                return URIConverter.INSTANCE.exists(input, Collections.EMPTY_MAP);
            }
        });
    }

    public IScope getScope(final Resource context, EReference reference, Predicate<IEObjectDescription> filter) {
        ArrayList descriptions = Lists.newArrayList();
        for (final URI uri : this.getValidLibraries(context)) {
            try {
                Iterables.addAll((Collection)descriptions, (Iterable)((Iterable)this.libraryCache.get((Object)uri, (Callable)new Callable<Iterable<IEObjectDescription>>(){

                    @Override
                    public Iterable<IEObjectDescription> call() throws Exception {
                        return AbstractLibraryGlobalScopeProvider.this.getDescriptions(context, uri);
                    }
                })));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return SelectableBasedScope.createScope((IScope)IScope.NULLSCOPE, (ISelectable)new EObjectDescriptionLookUp((List)descriptions), (EClass)reference.getEReferenceType(), (boolean)this.isIgnoreCase(reference));
    }

    protected Iterable<IEObjectDescription> getDescriptions(Resource context, URI uri) {
        ArrayList result = Lists.newArrayList();
        ResourceSetImpl set = new ResourceSetImpl();
        Resource resource = set.getResource(uri, true);
        IResourceServiceProvider resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            Iterables.addAll((Collection)result, (Iterable)Scopes.scopedElementsFor((Iterable)Lists.newArrayList((Iterator)resource.getAllContents())));
        } else {
            IResourceDescription resourceDescription = resourceServiceProvider.getResourceDescriptionManager().getResourceDescription(resource);
            Iterables.addAll((Collection)result, (Iterable)resourceDescription.getExportedObjects());
        }
        resource.unload();
        return result;
    }
}

