/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.types.inferrer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeAlias;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.base.types.validation.TypeValidator;
import org.eclipse.xtext.util.PolymorphicDispatcher;

public abstract class AbstractTypeSystemInferrer
implements ITypeSystemInferrer {
    protected static final String NO_INFER_METHOD = "No infer method for type(s) %s";
    protected static final String ASSERT_IS_TYPE = "Expected one of %s, but was %s.";
    public static final String ASSERT_NOT_TYPE = "Expected type is not %s.";
    public static final String ASSERT_SAME = "Expected types %s and %s are same.";
    public static final String ASSERT_COMPATIBLE = "Incompatible types %s and %s.";
    private static final String METHOD_NAME = "doInfer";
    @Inject
    protected ITypeSystem registry;
    @Inject
    protected TypeValidator typeValidator;
    protected IValidationIssueAcceptor acceptor;
    private PolymorphicDispatcher<Object> dispatcher;
    private LoadingCache<EObject, ITypeSystemInferrer.InferenceResult> typeCache;

    public AbstractTypeSystemInferrer() {
        this.initDispatcher();
    }

    protected ITypeSystemInferrer.InferenceResult getResultFor(String name) {
        return ITypeSystemInferrer.InferenceResult.from(this.registry.getType(name));
    }

    protected ITypeSystemInferrer.InferenceResult getCommonType(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2) {
        return ITypeSystemInferrer.InferenceResult.from(this.registry.getCommonType(result1.getType(), result2.getType()));
    }

    @Override
    public ITypeSystemInferrer.InferenceResult infer(EObject object) {
        return this.infer(object, null);
    }

    @Override
    public ITypeSystemInferrer.InferenceResult infer(EObject object, IValidationIssueAcceptor acceptor) {
        this.initTypeCache();
        this.acceptor = acceptor != null ? acceptor : new IValidationIssueAcceptor.ListBasedValidationIssueAcceptor();
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch(object);
        this.typeCache.invalidateAll();
        return result;
    }

    protected ITypeSystemInferrer.InferenceResult inferTypeDispatch(EObject object) {
        if (object == null || object.eIsProxy()) {
            return null;
        }
        try {
            return (ITypeSystemInferrer.InferenceResult)this.typeCache.get((Object)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void initTypeCache() {
        this.typeCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<EObject, ITypeSystemInferrer.InferenceResult>(){

            public ITypeSystemInferrer.InferenceResult load(EObject key) {
                if (key instanceof TypeAlias) {
                    return (ITypeSystemInferrer.InferenceResult)AbstractTypeSystemInferrer.this.dispatcher.invoke(new Object[]{key});
                }
                if (key instanceof Type) {
                    Collection<Type> types = AbstractTypeSystemInferrer.this.registry.getTypes();
                    for (Type type : types) {
                        if (!AbstractTypeSystemInferrer.this.registry.isSame((Type)key, type)) continue;
                        return ITypeSystemInferrer.InferenceResult.from(type);
                    }
                }
                return (ITypeSystemInferrer.InferenceResult)AbstractTypeSystemInferrer.this.dispatcher.invoke(new Object[]{key});
            }
        });
    }

    public void initDispatcher(List<ITypeSystemInferrer> targets) {
        this.dispatcher = new PolymorphicDispatcher(METHOD_NAME, 1, 1, targets, (PolymorphicDispatcher.ErrorHandler)new PolymorphicDispatcher.ErrorHandler<Object>(){

            public Object handle(Object[] params, Throwable throwable) {
                if (throwable instanceof NoSuchMethodError) {
                    AbstractTypeSystemInferrer.this.warning(String.format(AbstractTypeSystemInferrer.NO_INFER_METHOD, Arrays.toString(params)), "NoInferMethod");
                } else {
                    AbstractTypeSystemInferrer.this.error(throwable.getMessage(), "RuntimeException");
                }
                return null;
            }
        });
    }

    protected void initDispatcher() {
        this.initDispatcher(Collections.singletonList(this));
    }

    protected void assertNotType(ITypeSystemInferrer.InferenceResult currentResult, String msg, ITypeSystemInferrer.InferenceResult ... candidates) {
        this.typeValidator.assertNotType(currentResult, msg, this.acceptor, candidates);
    }

    protected void assertSame(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg) {
        this.typeValidator.assertSame(result1, result2, msg, this.acceptor);
    }

    protected void assertCompatible(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg) {
        this.typeValidator.assertCompatible(result1, result2, msg, this.acceptor);
    }

    protected void assertAssignable(ITypeSystemInferrer.InferenceResult varResult, ITypeSystemInferrer.InferenceResult valueResult, String msg) {
        this.typeValidator.assertAssignable(varResult, valueResult, msg, this.acceptor);
    }

    protected void assertTypeBindingsSame(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg) {
        this.typeValidator.assertTypeBindingsSame(result1, result2, msg, this.acceptor);
    }

    protected void assertIsSubType(ITypeSystemInferrer.InferenceResult subResult, ITypeSystemInferrer.InferenceResult superResult, String msg) {
        this.typeValidator.assertIsSubType(subResult, superResult, msg, this.acceptor);
    }

    protected void info(String msg, String issueCode) {
        this.acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.INFO, msg, issueCode));
    }

    protected void warning(String msg, String issueCode) {
        this.acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.WARNING, msg, issueCode));
    }

    protected void error(String msg, String issueCode) {
        this.acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, issueCode));
    }
}

