/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.stdlib.functions;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.NamedElement;
import org.eclipse.mita.library.stdlib.StringGenerator;
import org.eclipse.mita.program.InterpolatedStringExpression;
import org.eclipse.mita.program.generator.AbstractFunctionGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class LogGenerator
extends AbstractFunctionGenerator {
    @Inject
    protected StringGenerator stringGenerator;
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;

    public CodeFragment generate(ElementReferenceExpression function, IGeneratorNode resultVariableName) {
        EObject _reference = function.getReference();
        final String functionName = ((NamedElement)_reference).getName();
        IPlatformLoggingGenerator.LogLevel _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)functionName, (Object)"logDebug")) {
            _matched = true;
            _switchResult = IPlatformLoggingGenerator.LogLevel.Debug;
        }
        if (!_matched && Objects.equal((Object)functionName, (Object)"logInfo")) {
            _matched = true;
            _switchResult = IPlatformLoggingGenerator.LogLevel.Info;
        }
        if (!_matched && Objects.equal((Object)functionName, (Object)"logWarning")) {
            _matched = true;
            _switchResult = IPlatformLoggingGenerator.LogLevel.Warning;
        }
        if (!_matched && Objects.equal((Object)functionName, (Object)"logError")) {
            _matched = true;
            _switchResult = IPlatformLoggingGenerator.LogLevel.Error;
        }
        IPlatformLoggingGenerator.LogLevel level = _switchResult;
        Argument _head = (Argument)IterableExtensions.head((Iterable)function.getArguments());
        Expression _value = null;
        if (_head != null) {
            _value = _head.getValue();
        }
        Expression firstArg = _value;
        CodeFragment _xifexpression = null;
        if (firstArg instanceof InterpolatedStringExpression) {
            CodeFragment _xblockexpression = null;
            String pattern = this.stringGenerator.getPattern((InterpolatedStringExpression)firstArg);
            Functions.Function1<Expression, CodeFragment> _function = new Functions.Function1<Expression, CodeFragment>(){

                public CodeFragment apply(final Expression it) {
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            IGeneratorNode _generate = LogGenerator.this.generate((EObject)it);
                            _builder.append((Object)_generate);
                        }
                    };
                    return LogGenerator.this.codeFragmentProvider.create(_client);
                }
            };
            List args = ListExtensions.map((List)((InterpolatedStringExpression)firstArg).getContent(), (Functions.Function1)_function);
            _xifexpression = _xblockexpression = this.loggingGenerator.generateLogStatement(level, pattern, (CodeFragment[])Conversions.unwrapArray((Object)args, CodeFragment.class));
        } else {
            CodeFragment _xblockexpression_1 = null;
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Object pattern = StaticValueInferrer.infer((EObject)firstArg, (Procedures.Procedure1)_function);
            CodeFragment _xifexpression_1 = null;
            if (pattern instanceof String) {
                _xifexpression_1 = this.loggingGenerator.generateLogStatement(level, (String)pattern, new CodeFragment[0]);
            } else {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"#error ");
                        _builder.append((Object)functionName);
                        _builder.append((Object)" must only be called with a string literal or interpolated string");
                    }
                };
                _xifexpression_1 = this.codeFragmentProvider.create(_client);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        CodeFragment result = _xifexpression;
        return result.addHeader("stdio.h", true);
    }
}

