/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.AssignmentOperator;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.IGenerator;
import org.eclipse.mita.program.generator.TypeGenerator;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public abstract class AbstractTypeGenerator
implements IGenerator {
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    protected TypeGenerator typeGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateTypeSpecifier(final TypeSpecifier type, EObject context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _code = AbstractTypeGenerator.this.typeGenerator.code(type);
                _builder.append((Object)_code);
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateVariableDeclaration(final TypeSpecifier type, final VariableDeclaration stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _code = AbstractTypeGenerator.this.typeGenerator.code(type);
                _builder.append((Object)_code);
                _builder.append((Object)" ");
                String _name = stmt.getName();
                _builder.append((Object)_name);
                _builder.append((Object)";");
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public abstract CodeFragment generateNewInstance(TypeSpecifier var1, NewInstanceExpression var2);

    public boolean checkExpressionSupport(TypeSpecifier type, AssignmentOperator operator, TypeSpecifier otherType) {
        boolean _and = false;
        boolean _equals = Objects.equal((Object)operator, (Object)AssignmentOperator.ASSIGN);
        if (!_equals) {
            _and = false;
        } else {
            boolean _haveCommonType;
            Type _type = null;
            if (type != null) {
                _type = type.getType();
            }
            Type _type_1 = null;
            if (otherType != null) {
                _type_1 = otherType.getType();
            }
            _and = _haveCommonType = this.typeSystem.haveCommonType(_type, _type_1);
        }
        return _and;
    }

    public CodeFragment generateExpression(TypeSpecifier type, final EObject left, final AssignmentOperator operator, final EObject right) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)left);
                _builder.append((Object)" ");
                String _literal = operator.getLiteral();
                _builder.append((Object)_literal);
                _builder.append((Object)" ");
                _builder.append((Object)right);
                _builder.append((Object)";");
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateHeader() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateHeader(TypeSpecifier type) {
        return CodeFragment.EMPTY;
    }
}

