/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mita.base.scoping.ILibraryProvider;
import org.eclipse.mita.base.types.PackageAssociation;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.platform.SystemSpecification;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.CompilationContextProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformMakefileGenerator;
import org.eclipse.mita.program.generator.ProgramDslTraceExtensions;
import org.eclipse.mita.program.generator.internal.EntryPointGenerator;
import org.eclipse.mita.program.generator.internal.ExceptionGenerator;
import org.eclipse.mita.program.generator.internal.GeneratedTypeGenerator;
import org.eclipse.mita.program.generator.internal.IGeneratorOnResourceSet;
import org.eclipse.mita.program.generator.internal.ProgramCopier;
import org.eclipse.mita.program.generator.internal.SystemResourceHandlingGenerator;
import org.eclipse.mita.program.generator.internal.TimeEventGenerator;
import org.eclipse.mita.program.generator.internal.UserCodeFileGenerator;
import org.eclipse.mita.program.generator.transformation.ProgramGenerationTransformationPipeline;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.resource.PluginResourceLoader;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.service.DefaultRuntimeModule;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ProgramDslGenerator
extends AbstractGenerator
implements IGeneratorOnResourceSet {
    @Inject
    @Extension
    protected ProgramDslTraceExtensions _programDslTraceExtensions;
    @Inject
    @Extension
    protected ProgramCopier _programCopier;
    @Inject
    protected Provider<ProgramGenerationTransformationPipeline> transformer;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject(optional=true)
    protected IPlatformMakefileGenerator makefileGenerator;
    @Inject
    protected EntryPointGenerator entryPointGenerator;
    @Inject
    protected ExceptionGenerator exceptionGenerator;
    @Inject
    protected GeneratedTypeGenerator generatedTypeGenerator;
    @Inject
    protected TimeEventGenerator timeEventGenerator;
    @Inject
    protected SystemResourceHandlingGenerator systemResourceGenerator;
    @Inject
    protected UserCodeFileGenerator userCodeGenerator;
    @Inject
    protected Injector injector;
    @Inject
    protected ILibraryProvider libraryProvider;
    @Inject
    @Named(value="injectingModule")
    protected DefaultRuntimeModule injectingModule;
    @Inject
    protected CompilationContextProvider compilationContextProvider;
    @Inject
    protected ModelUtils modelUtils;
    @Inject
    protected PluginResourceLoader resourceLoader;

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        this.doGenerate(resource.getResourceSet(), fsa);
    }

    protected boolean isMainApplicationFile(Resource resource) {
        return ((String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)resource.getURI().segments())))).startsWith("application.");
    }

    protected void injectPlatformDependencies(Module libraryModule) {
        this.injector = Guice.createInjector((Module[])new Module[]{this.injectingModule, libraryModule});
        this.injector.injectMembers((Object)this);
    }

    private String produceFile(IFileSystemAccess2 fsa, String path, EObject ctx, CompositeGeneratorNode content) {
        CompositeGeneratorNode root = CodeFragment.cleanNullChildren(content);
        this._programDslTraceExtensions.generateTracedFile(fsa, path, root);
        return path;
    }

    @Override
    public void doGenerate(ResourceSet input, IFileSystemAccess2 fsa) {
        Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

            public Boolean apply(Resource it) {
                URI _uRI = it.getURI();
                String _segment = null;
                if (_uRI != null) {
                    _segment = _uRI.segment(0);
                }
                return Objects.equal(_segment, (Object)"resource");
            }
        };
        this.doGenerate(input, fsa, _function);
    }

    @Override
    public void doGenerate(final ResourceSet input, IFileSystemAccess2 fsa, Functions.Function1<Resource, Boolean> includeInBuildPredicate) {
        CodeFragment codefragment;
        String _produceFile_7;
        String _plus;
        List resourcesToCompile = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)input.getResources(), includeInBuildPredicate));
        boolean _isEmpty = resourcesToCompile.isEmpty();
        if (_isEmpty) {
            return;
        }
        Iterable libs = this.libraryProvider.getDefaultLibraries();
        Functions.Function1<URI, Boolean> _function = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                return it.toString().endsWith(".mita");
            }
        };
        Iterable stdlibUri = IterableExtensions.filter((Iterable)libs, (Functions.Function1)_function);
        Functions.Function1<URI, Program> _function_1 = new Functions.Function1<URI, Program>(){

            public Program apply(URI it) {
                return (Program)IterableExtensions.head((Iterable)Iterables.filter((Iterable)input.getResource(it, true).getContents(), Program.class));
            }
        };
        Iterable stdlib = IterableExtensions.map((Iterable)stdlibUri, (Functions.Function1)_function_1);
        Functions.Function1<Resource, Program> _function_2 = new Functions.Function1<Resource, Program>(){

            public Program apply(Resource x) {
                return (Program)IterableExtensions.head((Iterable)Iterables.filter((Iterable)x.getContents(), Program.class));
            }
        };
        Functions.Function1<Program, Program> _function_3 = new Functions.Function1<Program, Program>(){

            public Program apply(Program x) {
                return ((ProgramGenerationTransformationPipeline)ProgramDslGenerator.this.transformer.get()).transform(ProgramDslGenerator.this._programCopier.copy(x));
            }
        };
        List compilationUnits = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)resourcesToCompile, (Functions.Function1)_function_2)), (Functions.Function1)_function_3));
        Program someProgram = (Program)IterableExtensions.head((Iterable)compilationUnits);
        Platform platform = this.modelUtils.getPlatform(someProgram);
        Object _loadFromPlugin = this.resourceLoader.loadFromPlugin(platform.eResource(), platform.getModule());
        this.injectPlatformDependencies((Module)_loadFromPlugin);
        CompilationContext context = this.compilationContextProvider.get(compilationUnits, stdlib);
        LinkedList<String> files = new LinkedList<String>();
        LinkedList<String> userTypeFiles = new LinkedList<String>();
        String _produceFile = this.produceFile(fsa, "main.c", (EObject)someProgram, this.entryPointGenerator.generateMain(context));
        files.add(_produceFile);
        String _produceFile_1 = this.produceFile(fsa, "base/MitaEvents.h", (EObject)someProgram, this.entryPointGenerator.generateEventHeader(context));
        files.add(_produceFile_1);
        String _produceFile_2 = this.produceFile(fsa, "base/MitaExceptions.h", (EObject)someProgram, this.exceptionGenerator.generateHeader(context));
        files.add(_produceFile_2);
        boolean _hasTimeEvents = context.hasTimeEvents();
        if (_hasTimeEvents) {
            String _produceFile_3 = this.produceFile(fsa, "base/MitaTime.h", (EObject)someProgram, this.timeEventGenerator.generateHeader(context));
            files.add(_produceFile_3);
            String _produceFile_4 = this.produceFile(fsa, "base/MitaTime.c", (EObject)someProgram, this.timeEventGenerator.generateImplementation(context));
            files.add(_produceFile_4);
        }
        Iterable _filter = Iterables.filter(context.getResourceGraph().getNodes(), EObject.class);
        for (EObject resourceOrSetup : _filter) {
            if (!(resourceOrSetup instanceof AbstractSystemResource) && !(resourceOrSetup instanceof SystemResourceSetup)) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("base/");
            String _fileBasename = this._generatorUtils.getFileBasename(resourceOrSetup);
            _builder.append(_fileBasename);
            _builder.append(".h");
            String _produceFile_5 = this.produceFile(fsa, _builder.toString(), resourceOrSetup, this.systemResourceGenerator.generateHeader(context, resourceOrSetup));
            files.add(_produceFile_5);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("base/");
            String _fileBasename_1 = this._generatorUtils.getFileBasename(resourceOrSetup);
            _builder_1.append(_fileBasename_1);
            _builder_1.append(".c");
            String _produceFile_6 = this.produceFile(fsa, _builder_1.toString(), resourceOrSetup, this.systemResourceGenerator.generateImplementation(context, resourceOrSetup));
            files.add(_produceFile_6);
            Iterable<String> _generateAdditionalFiles = this.systemResourceGenerator.generateAdditionalFiles(fsa, context, resourceOrSetup);
            Iterables.addAll(files, _generateAdditionalFiles);
        }
        Functions.Function1<Program, Boolean> _function_4 = new Functions.Function1<Program, Boolean>(){

            public Boolean apply(Program it) {
                return ProgramDslGenerator.this._generatorUtils.containsCodeRelevantContent(it);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)compilationUnits, (Functions.Function1)_function_4);
        for (Program program : _filter_1) {
            String _resourceBaseName = UserCodeFileGenerator.getResourceBaseName(program);
            _plus = String.valueOf(_resourceBaseName) + ".c";
            _produceFile_7 = this.produceFile(fsa, _plus, (EObject)program, this._programDslTraceExtensions.append(this._programDslTraceExtensions.trace((EObject)IterableExtensions.head((Iterable)stdlib)), this.userCodeGenerator.generateImplementation(context, program)));
            files.add(_produceFile_7);
            String _resourceBaseName_1 = UserCodeFileGenerator.getResourceBaseName(program);
            String _plus_1 = String.valueOf(_resourceBaseName_1) + ".h";
            String _produceFile_8 = this.produceFile(fsa, _plus_1, (EObject)program, this._programDslTraceExtensions.append(this._programDslTraceExtensions.trace((EObject)IterableExtensions.head((Iterable)stdlib)), this.userCodeGenerator.generateHeader(context, program)));
            files.add(_produceFile_8);
            String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(program);
            String compilationUnitTypesFilename = String.valueOf(_resourceTypesName) + ".h";
            String _produceFile_9 = this.produceFile(fsa, compilationUnitTypesFilename, (EObject)program, this._programDslTraceExtensions.append(this._programDslTraceExtensions.trace((EObject)IterableExtensions.head((Iterable)stdlib)), this.userCodeGenerator.generateTypes(context, program)));
            files.add(_produceFile_9);
            userTypeFiles.add(compilationUnitTypesFilename);
        }
        EObject _eContainer = platform.eContainer();
        SystemSpecification platformSpec = (SystemSpecification)_eContainer;
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName((PackageAssociation)platformSpec);
        _plus = String.valueOf(_resourceTypesName) + ".h";
        _produceFile_7 = this.produceFile(fsa, _plus, (EObject)platform, this._programDslTraceExtensions.append(this._programDslTraceExtensions.trace((EObject)IterableExtensions.head((Iterable)stdlib)), this.userCodeGenerator.generateTypes(context, platformSpec)));
        files.add(_produceFile_7);
        String _produceFile_8 = this.produceFile(fsa, "base/MitaGeneratedTypes.h", (EObject)someProgram, this.generatedTypeGenerator.generateHeader(context, userTypeFiles));
        files.add(_produceFile_8);
        Iterable<String> _userFiles = this.getUserFiles(input);
        Iterables.addAll(files, _userFiles);
        CodeFragment _generateMakefile = null;
        if (this.makefileGenerator != null) {
            _generateMakefile = this.makefileGenerator.generateMakefile(compilationUnits, files);
        }
        if ((codefragment = _generateMakefile) != null && !Objects.equal((Object)((Object)codefragment), (Object)((Object)CodeFragment.EMPTY))) {
            this.produceFile(fsa, "Makefile", (EObject)someProgram, codefragment);
        }
    }

    public Iterable<String> getUserFiles(ResourceSet set) {
        try {
            Resource resource = (Resource)IterableExtensions.head((Iterable)set.getResources());
            URI uri = resource.getURI();
            String _platformString = uri.toPlatformString(true);
            String projectName = new Path(_platformString).segment(0);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = workspaceRoot.getProject(projectName);
            Functions.Function1<IFile, String> _function = new Functions.Function1<IFile, String>(){

                public String apply(IFile it) {
                    return it.getFullPath().lastSegment();
                }
            };
            Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    return it.endsWith(".c");
                }
            };
            Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return "../" + it;
                }
            };
            return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)project.members())), IFile.class), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

