/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.ConfigurationItem;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.internal.IResourceGraph;
import org.eclipse.mita.program.generator.internal.ResourceGraphImpl;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ResourceGraphBuilder {
    @Inject
    protected ITypeSystemInferrer typeSystemInferrer;
    protected final Set<Object> nodes = new HashSet<Object>();
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    protected Map<String, NodeMark> nodeMarks = new TreeMap<String, NodeMark>();
    protected Map<String, List<String>> edges = new TreeMap<String, List<String>>();
    protected Iterable<EObject> sortedNodes = Collections.unmodifiableList(CollectionLiterals.newArrayList());
    protected boolean isDag = true;

    protected Iterable<EObject> _doComputeDependencies(Program program) {
        Functions.Function1<SignalInstance, EObject> _function = new Functions.Function1<SignalInstance, EObject>(){

            public EObject apply(SignalInstance it) {
                return it.eContainer();
            }
        };
        Set siginstAccess = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)program.eAllContents(), SignalInstance.class), (Functions.Function1)_function), EObject.class));
        Functions.Function1<ModalityAccess, AbstractSystemResource> _function_1 = new Functions.Function1<ModalityAccess, AbstractSystemResource>(){

            public AbstractSystemResource apply(ModalityAccess it) {
                return it.getPreparation().getSystemResource();
            }
        };
        List modalityAccess = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)program.eAllContents(), ModalityAccess.class), (Functions.Function1)_function_1), EObject.class));
        Functions.Function1<EventHandlerDeclaration, Boolean> _function_2 = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration it) {
                EventSource _event = it.getEvent();
                return _event instanceof SystemEventSource;
            }
        };
        Functions.Function1<EventHandlerDeclaration, AbstractSystemResource> _function_3 = new Functions.Function1<EventHandlerDeclaration, AbstractSystemResource>(){

            public AbstractSystemResource apply(EventHandlerDeclaration it) {
                EventSource _event = it.getEvent();
                return ((SystemEventSource)_event).getOrigin();
            }
        };
        Functions.Function1<AbstractSystemResource, Boolean> _function_4 = new Functions.Function1<AbstractSystemResource, Boolean>(){

            public Boolean apply(AbstractSystemResource it) {
                return !(it instanceof Platform);
            }
        };
        Iterable eventsHandled = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(program.getEventHandlers(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
        Iterable _plus = Iterables.concat((Iterable)siginstAccess, (Iterable)modalityAccess);
        return Iterables.concat((Iterable)_plus, (Iterable)eventsHandled);
    }

    protected Iterable<EObject> _doComputeDependencies(AbstractSystemResource resource) {
        Functions.Function1<ConfigurationItem, Boolean> _function = new Functions.Function1<ConfigurationItem, Boolean>(){

            public Boolean apply(ConfigurationItem it) {
                ITypeSystemInferrer.InferenceResult _infer = ResourceGraphBuilder.this.typeSystemInferrer.infer((EObject)it);
                Type _type = null;
                if (_infer != null) {
                    _type = _infer.getType();
                }
                return _type instanceof AbstractSystemResource;
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.filter((Iterable)resource.getConfigurationItems(), (Functions.Function1)_function), EObject.class));
    }

    protected Iterable<EObject> _doComputeDependencies(SystemResourceSetup setup) {
        Functions.Function1<ElementReferenceExpression, EObject> _function = new Functions.Function1<ElementReferenceExpression, EObject>(){

            public EObject apply(ElementReferenceExpression it) {
                return it.getReference();
            }
        };
        Functions.Function1<EObject, Boolean> _function_1 = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject it) {
                return it instanceof AbstractSystemResource || it instanceof SystemResourceSetup;
            }
        };
        return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)setup.eAllContents(), ElementReferenceExpression.class), (Functions.Function1)_function), (Functions.Function1)_function_1), EObject.class));
    }

    protected Iterable<EObject> _doComputeDependencies(EObject obj) {
        return Collections.emptyList();
    }

    protected Iterable<EObject> computeDependencies(EObject obj) {
        return this.doComputeDependencies(obj);
    }

    public void addNode(EObject node) {
        this.visit(node);
    }

    protected void visit(EObject node) {
        Iterable _plus;
        String nodeId = this.getID(node);
        if (nodeId == null) {
            throw new IllegalArgumentException("Cannot compute an ID for the node");
        }
        NodeMark mark = this.nodeMarks.getOrDefault(nodeId, NodeMark.None);
        boolean _equals = Objects.equal((Object)((Object)mark), (Object)((Object)NodeMark.Perm));
        if (_equals) {
            return;
        }
        boolean _equals_1 = Objects.equal((Object)((Object)mark), (Object)((Object)NodeMark.Temp));
        if (_equals_1) {
            this.isDag = false;
            return;
        }
        this.nodeMarks.put(nodeId, NodeMark.Temp);
        Functions.Function1<EObject, String> _function = new Functions.Function1<EObject, String>(){

            public String apply(EObject it) {
                ResourceGraphBuilder.this.visit(it);
                return ResourceGraphBuilder.this.getID(it);
            }
        };
        this.edges.put(nodeId, IterableExtensions.toList((Iterable)IterableExtensions.map(this.computeDependencies(node), (Functions.Function1)_function)));
        this.nodeMarks.put(nodeId, NodeMark.Perm);
        this.sortedNodes = _plus = Iterables.concat(this.sortedNodes, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{node})));
    }

    public IResourceGraph<EObject> build() {
        Functions.Function1<Map.Entry<String, List<String>>, Iterable<Pair<String, String>>> _function = new Functions.Function1<Map.Entry<String, List<String>>, Iterable<Pair<String, String>>>(){

            public Iterable<Pair<String, String>> apply(final Map.Entry<String, List<String>> a) {
                Functions.Function1<String, Pair<String, String>> _function = new Functions.Function1<String, Pair<String, String>>(){

                    public Pair<String, String> apply(String b) {
                        String _key = (String)a.getKey();
                        return Pair.of((Object)_key, (Object)b);
                    }
                };
                return ListExtensions.map(a.getValue(), (Functions.Function1)_function);
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap(this.edges.entrySet(), (Functions.Function1)_function);
        return new ResourceGraphImpl<EObject>(this.sortedNodes, _flatMap, this.isDag);
    }

    protected String getID(EObject obj) {
        String _computeID;
        QualifiedName _fullyQualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(obj);
        String _string = null;
        if (_fullyQualifiedName != null) {
            _string = _fullyQualifiedName.toString();
        }
        String fqn = _string;
        String _elvis = null;
        _elvis = fqn != null ? fqn : (_computeID = this.computeID(obj));
        return _elvis;
    }

    protected String _computeID(EObject obj) {
        return null;
    }

    protected Iterable<EObject> doComputeDependencies(EObject resource) {
        if (resource instanceof AbstractSystemResource) {
            return this._doComputeDependencies((AbstractSystemResource)resource);
        }
        if (resource instanceof Program) {
            return this._doComputeDependencies((Program)resource);
        }
        if (resource instanceof SystemResourceSetup) {
            return this._doComputeDependencies((SystemResourceSetup)resource);
        }
        if (resource != null) {
            return this._doComputeDependencies(resource);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(resource).toString());
    }

    protected String computeID(EObject obj) {
        return this._computeID(obj);
    }

    public static class GraphIsNotAcyclicException
    extends Exception {
    }

    public static enum NodeMark {
        None,
        Temp,
        Perm;

    }
}

