/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.validation;

import com.google.inject.Inject;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.base.types.validation.TypeValidator;
import org.eclipse.mita.program.inferrer.OptionalTypeExtensions;

public class ProgramDslTypeValidator
extends TypeValidator {
    @Inject
    private OptionalTypeExtensions optionalTypeHelper;

    public void assertAssignable(ITypeSystemInferrer.InferenceResult varResult, ITypeSystemInferrer.InferenceResult valueResult, String msg, IValidationIssueAcceptor acceptor) {
        if (varResult == null || valueResult == null) {
            return;
        }
        if (this.optionalTypeHelper.isOptional(varResult.getType()) && !this.optionalTypeHelper.isOptional(valueResult.getType())) {
            varResult = this.optionalTypeHelper.getOptionalBaseType(varResult);
        }
        if (this.isSuperTypeLiteralAssignment(varResult, valueResult, "integer") || this.isValidRealLiteralAssignment(varResult, valueResult) || this.isSuperTypeLiteralAssignment(varResult, valueResult, "boolean") || this.isSuperTypeLiteralAssignment(varResult, valueResult, "string")) {
            return;
        }
        super.assertAssignable(varResult, valueResult, msg, acceptor);
    }

    public void assertSame(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg, IValidationIssueAcceptor acceptor) {
        if (result1 == null || result2 == null) {
            return;
        }
        if (this.isSuperTypeLiteralAssignment(result1, result2, "integer") || this.isValidRealLiteralAssignment(result1, result2) || this.isSuperTypeLiteralAssignment(result1, result2, "boolean") || this.isSuperTypeLiteralAssignment(result1, result2, "string")) {
            return;
        }
        super.assertSame(result1, result2, msg, acceptor);
    }

    public void assertCompatible(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg, IValidationIssueAcceptor acceptor) {
        if (result1 == null || result2 == null) {
            return;
        }
        result1 = this.optionalTypeHelper.getOptionalBaseType(result1);
        result2 = this.optionalTypeHelper.getOptionalBaseType(result2);
        super.assertCompatible(result1, result2, msg, acceptor);
    }

    protected boolean isSuperTypeLiteralAssignment(ITypeSystemInferrer.InferenceResult varResult, ITypeSystemInferrer.InferenceResult valueResult, String literalTypeName) {
        return this.registry.isSame(valueResult.getType(), this.registry.getType(literalTypeName)) && this.registry.isSuperType(varResult.getType(), this.registry.getType(literalTypeName));
    }

    protected boolean isValidRealLiteralAssignment(ITypeSystemInferrer.InferenceResult varResult, ITypeSystemInferrer.InferenceResult valueResult) {
        return this.registry.isSuperType(valueResult.getType(), this.registry.getType("real")) && this.registry.isSuperType(varResult.getType(), this.registry.getType("real")) && !this.registry.isSuperType(varResult.getType(), this.registry.getType("integer"));
    }
}

