/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.validation;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.AssignmentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.DereferenceExpression;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.FunctionParameterDeclaration;
import org.eclipse.mita.program.ReferenceExpression;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.inferrer.ProgramDslTypeInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ReferenceTypesValidator
extends AbstractDeclarativeValidator
implements IValidationIssueAcceptor {
    @Inject
    @Extension
    private ProgramDslTypeInferrer inferrer;
    @Inject
    private ITypeSystem typeSystem;
    public static final String REFERENCE_TYPE = "reference";
    public static final String CANT_ASSIGN_TO_REFERENCES_THAT_WERE_PASSED_IN = "Can not assign to references that were passed in.";
    public static final String CANT_REFERENCE_FUNCTION_PARAMETER_REFERENCES = "Can not reference function parameter references.";
    public static final String CANT_REFERENCE_FUNCTION_RESULTS = "Can not reference function results.";
    public static final String CANT_COPY_FUNCTION_PARAMETER_REF_REF = "Can not copy function parameters that are or contain references of references.";
    public static final String STRUCTURAL_TYPES_CANT_CONTAIN_REF_REFS = "Structural types can't contain references to references.";
    public static final String FORBIDDEN_RETURN = "Functions may not return references";
    public static final String TYPES_WITH_REFERENCES_MUST_BE_INITIALIZED = "Types with references must be initialized";

    @Check
    public Object checkAssignmentToReferenceOfReference(AssignmentExpression e) {
        return null;
    }

    @Check
    public void checkAssignmentExpression(AssignmentExpression e) {
        boolean _tripleNotEquals;
        Expression _expression = e.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            this.checkRHS1((EObject)e, (EObject)e.getExpression());
            this.checkLHS1((EObject)e, e.getVarRef());
        }
    }

    @Check
    public void checkVariableDeclaration(VariableDeclaration e) {
        boolean _tripleNotEquals;
        Expression _initialization = e.getInitialization();
        boolean bl = _tripleNotEquals = _initialization != null;
        if (_tripleNotEquals) {
            this.checkRHS1(e, (EObject)e.getInitialization());
        } else {
            ITypeSystemInferrer.InferenceResult typeIR = this.inferrer.infer(e);
            boolean _hasReferenceInType = this.hasReferenceInType(typeIR);
            if (_hasReferenceInType) {
                this.error(TYPES_WITH_REFERENCES_MUST_BE_INITIALIZED, e, null);
            }
        }
    }

    public void checkLHS1(EObject source, Expression varRef) {
        boolean _isSuperType;
        Triple<Integer, Boolean, List<EObject>> isRefRef = this.innerMostReferences((EObject)varRef);
        ITypeSystemInferrer.InferenceResult outerType = this.inferrer.infer((EObject)varRef, this);
        boolean _and = false;
        Type _type = null;
        if (outerType != null) {
            _type = outerType.getType();
        }
        if (!(_isSuperType = this.typeSystem.isSuperType(_type, this.typeSystem.getType(REFERENCE_TYPE)))) {
            _and = false;
        } else {
            Boolean _second = (Boolean)isRefRef.getSecond();
            _and = _second;
        }
        if (_and) {
            this.error(CANT_ASSIGN_TO_REFERENCES_THAT_WERE_PASSED_IN, source, null);
        }
    }

    @Check
    public void checkNoRefOfFunResult(ReferenceExpression e) {
        Expression variable = e.getVariable();
        this.checkNoFunCall((EObject)variable, (EObject)e);
    }

    @Check
    public void forbiddenReferenceReturn(ReturnStatement stmt) {
        FunctionDefinition funDecl = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)stmt, FunctionDefinition.class);
        ITypeSystemInferrer.InferenceResult funDeclTypeIR = this.inferrer.infer((EObject)funDecl);
        boolean _hasReferenceInType = this.hasReferenceInType(funDeclTypeIR);
        if (_hasReferenceInType) {
            this.error(FORBIDDEN_RETURN, stmt, null);
        }
    }

    @Check
    public void forbiddenReferenceReturn(FunctionDefinition funDecl) {
        ITypeSystemInferrer.InferenceResult funDeclTypeIR = this.inferrer.infer((EObject)funDecl);
        boolean _hasReferenceInType = this.hasReferenceInType(funDeclTypeIR);
        if (_hasReferenceInType) {
            this.error(FORBIDDEN_RETURN, (EObject)funDecl, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    public boolean hasReferenceInType(ITypeSystemInferrer.InferenceResult ir) {
        boolean _equals;
        if (ir == null) {
            return false;
        }
        Type _type = null;
        if (ir != null) {
            _type = ir.getType();
        }
        String _name = null;
        if (_type != null) {
            _name = _type.getName();
        }
        if (_equals = Objects.equal((Object)_name, (Object)REFERENCE_TYPE)) {
            return true;
        }
        Functions.Function2<Boolean, ITypeSystemInferrer.InferenceResult, Boolean> _function = new Functions.Function2<Boolean, ITypeSystemInferrer.InferenceResult, Boolean>(){

            public Boolean apply(Boolean b, ITypeSystemInferrer.InferenceResult i) {
                return b != false || ReferenceTypesValidator.this.hasReferenceInType(i);
            }
        };
        return (Boolean)IterableExtensions.fold((Iterable)ir.getBindings(), (Object)false, (Functions.Function2)_function);
    }

    protected void _checkNoFunCall(ArrayAccessExpression a, EObject source) {
        this.checkNoFunCall((EObject)a.getOwner(), source);
    }

    protected void _checkNoFunCall(FeatureCall a, EObject source) {
        boolean _isOperationCall = a.isOperationCall();
        if (_isOperationCall) {
            this.error(CANT_REFERENCE_FUNCTION_RESULTS, source, null);
        }
        this.checkNoFunCall((EObject)a.getOwner(), source);
    }

    protected void _checkNoFunCall(ElementReferenceExpression a, EObject source) {
        boolean _isOperationCall = a.isOperationCall();
        if (_isOperationCall) {
            this.error(CANT_REFERENCE_FUNCTION_RESULTS, source, null);
        }
        this.checkNoFunCall(a.getReference(), source);
    }

    protected void _checkNoFunCall(EObject e, EObject source) {
    }

    protected void _checkRHS1(EObject source, ReferenceExpression e) {
        this.checkRHS1(source, (EObject)e.getVariable());
    }

    protected void _checkRHS1(EObject source, EObject e) {
        Triple<Integer, Boolean, List<EObject>> ref = this.innerMostReferences(e);
        Boolean _second = (Boolean)ref.getSecond();
        if (_second.booleanValue()) {
            boolean _greaterThan;
            ITypeSystemInferrer.InferenceResult eType = this.inferrer.infer(e, this);
            Integer _maxRefCount = this.maxRefCount(ModelUtils.toSpecifier(eType));
            boolean bl = _greaterThan = _maxRefCount > 0;
            if (_greaterThan) {
                this.error(CANT_COPY_FUNCTION_PARAMETER_REF_REF, source, null);
            }
        }
    }

    protected Integer _maxRefCount(TypeSpecifier ts) {
        Integer _maxRefCount = this.maxRefCount(ts.getType());
        int _xifexpression = 0;
        boolean _isSuperType = this.typeSystem.isSuperType(ts.getType(), this.typeSystem.getType(REFERENCE_TYPE));
        if (_isSuperType) {
            Integer _maxRefCount_1 = this.maxRefCount(IterableExtensions.head((Iterable)ts.getTypeArguments()));
            _xifexpression = 1 + _maxRefCount_1;
        } else {
            _xifexpression = 0;
        }
        return _maxRefCount + _xifexpression;
    }

    protected Integer _maxRefCount(StructureType s) {
        Functions.Function1<Parameter, Integer> _function = new Functions.Function1<Parameter, Integer>(){

            public Integer apply(Parameter it) {
                return ReferenceTypesValidator.this.maxRefCount(it.getTypeSpecifier());
            }
        };
        return (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)s.getParameters(), (Functions.Function1)_function));
    }

    protected Integer _maxRefCount(AnonymousProductType s) {
        Functions.Function1<TypeSpecifier, Integer> _function = new Functions.Function1<TypeSpecifier, Integer>(){

            public Integer apply(TypeSpecifier it) {
                return ReferenceTypesValidator.this.maxRefCount(it);
            }
        };
        return (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)s.getTypeSpecifiers(), (Functions.Function1)_function));
    }

    protected Integer _maxRefCount(NamedProductType s) {
        Functions.Function1<Parameter, Integer> _function = new Functions.Function1<Parameter, Integer>(){

            public Integer apply(Parameter it) {
                return ReferenceTypesValidator.this.maxRefCount(it.getTypeSpecifier());
            }
        };
        return (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)s.getParameters(), (Functions.Function1)_function));
    }

    protected Integer _maxRefCount(Object o) {
        return 0;
    }

    protected Integer _maxRefCount(Void o) {
        return 0;
    }

    public Optional<Pair<Integer, TypeSpecifier>> typeSpecifierContainsRefRefs(TypeSpecifier ts) {
        Optional<Pair<Integer, TypeSpecifier>> _structuralFeatureContainsRefRefs = this.structuralFeatureContainsRefRefs((EObject)ts.getType());
        Optional<Pair<Integer, TypeSpecifier>> _xifexpression = null;
        boolean _isSuperType = this.typeSystem.isSuperType(ts.getType(), this.typeSystem.getType(REFERENCE_TYPE));
        _xifexpression = _isSuperType ? this.typeSpecifierContainsRefRefs((TypeSpecifier)IterableExtensions.head((Iterable)ts.getTypeArguments())) : Optional.absent();
        return _structuralFeatureContainsRefRefs.or((Optional)_xifexpression);
    }

    protected Triple<Integer, Boolean, List<EObject>> _innerMostReferences(DereferenceExpression e) {
        boolean _tripleEquals;
        Triple _xblockexpression = null;
        Expression _expression = e.getExpression();
        boolean bl = _tripleEquals = _expression == null;
        if (_tripleEquals) {
            return Tuples.create((Object)0, (Object)false, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{e})));
        }
        Triple<Integer, Boolean, List<EObject>> ce = this.innerMostReferences((EObject)e.getExpression());
        Integer _first = (Integer)ce.getFirst();
        int _plus = _first + 1;
        _xblockexpression = Tuples.create((Object)_plus, (Object)((Boolean)ce.getSecond()), (Object)((List)ce.getThird()));
        return _xblockexpression;
    }

    protected Triple<Integer, Boolean, List<EObject>> _innerMostReferences(FeatureCall e) {
        Triple _xifexpression = null;
        boolean _isOperationCall = e.isOperationCall();
        if (_isOperationCall) {
            _xifexpression = Tuples.create((Object)0, (Object)false, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{e})));
        } else {
            Triple _xblockexpression = null;
            Triple<Integer, Boolean, List<EObject>> t1 = this.innerMostReferences(e.getFeature());
            Triple<Integer, Boolean, List<EObject>> t2 = this.innerMostReferences((EObject)e.getOwner());
            Integer _first = (Integer)t1.getFirst();
            Integer _first_1 = (Integer)t2.getFirst();
            int _plus = _first + _first_1;
            List _third = (List)t1.getThird();
            List _third_1 = (List)t2.getThird();
            _xifexpression = _xblockexpression = Tuples.create((Object)_plus, (Object)((Boolean)t1.getSecond() != false || (Boolean)t2.getSecond() != false ? 1 : 0), (Object)IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_third, (Iterable)_third_1)));
        }
        return _xifexpression;
    }

    protected Triple<Integer, Boolean, List<EObject>> _innerMostReferences(ElementReferenceExpression e) {
        return this.innerMostReferences(e.getReference());
    }

    protected Triple<Integer, Boolean, List<EObject>> _innerMostReferences(FunctionParameterDeclaration fpd) {
        return Tuples.create((Object)0, (Object)true, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{fpd})));
    }

    protected Triple<Integer, Boolean, List<EObject>> _innerMostReferences(EObject e) {
        return Tuples.create((Object)0, (Object)false, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{e})));
    }

    protected Triple<Integer, Boolean, List<EObject>> _innerMostReferences(Void e) {
        return Tuples.create((Object)0, (Object)false, Collections.unmodifiableList(CollectionLiterals.newArrayList()));
    }

    protected Optional<Pair<Integer, TypeSpecifier>> _structuralFeatureContainsRefRefs(StructureType s) {
        Functions.Function1<Parameter, TypeSpecifier> _function = new Functions.Function1<Parameter, TypeSpecifier>(){

            public TypeSpecifier apply(Parameter it) {
                return it.getTypeSpecifier();
            }
        };
        return this.typeSpecsContainRefRefs(ListExtensions.map((List)s.getParameters(), (Functions.Function1)_function));
    }

    protected Optional<Pair<Integer, TypeSpecifier>> _structuralFeatureContainsRefRefs(AnonymousProductType s) {
        return this.typeSpecsContainRefRefs((List<TypeSpecifier>)s.getTypeSpecifiers());
    }

    protected Optional<Pair<Integer, TypeSpecifier>> _structuralFeatureContainsRefRefs(NamedProductType s) {
        Functions.Function1<Parameter, TypeSpecifier> _function = new Functions.Function1<Parameter, TypeSpecifier>(){

            public TypeSpecifier apply(Parameter it) {
                return it.getTypeSpecifier();
            }
        };
        return this.typeSpecsContainRefRefs(ListExtensions.map((List)s.getParameters(), (Functions.Function1)_function));
    }

    protected Optional<Pair<Integer, TypeSpecifier>> _structuralFeatureContainsRefRefs(EObject e) {
        return Optional.absent();
    }

    public Optional<Pair<Integer, TypeSpecifier>> typeSpecsContainRefRefs(List<TypeSpecifier> tss) {
        Iterable _indexed = IterableExtensions.indexed(tss);
        for (Pair idx_ts : _indexed) {
            TypeSpecifier innerType;
            boolean _isSuperType_1;
            boolean _isSuperType = this.typeSystem.isSuperType(((TypeSpecifier)idx_ts.getValue()).getType(), this.typeSystem.getType(REFERENCE_TYPE));
            if (!_isSuperType || !(_isSuperType_1 = this.typeSystem.isSuperType((innerType = (TypeSpecifier)IterableExtensions.head((Iterable)((TypeSpecifier)idx_ts.getValue()).getTypeArguments())).getType(), this.typeSystem.getType(REFERENCE_TYPE)))) continue;
            return Optional.of((Object)idx_ts);
        }
        return null;
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }

    public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
        this.error(issue.getMessage(), issue.getTarget(), null);
    }

    public void checkNoFunCall(EObject a, EObject source) {
        if (a instanceof ElementReferenceExpression) {
            this._checkNoFunCall((ElementReferenceExpression)a, source);
            return;
        }
        if (a instanceof FeatureCall) {
            this._checkNoFunCall((FeatureCall)a, source);
            return;
        }
        if (a instanceof ArrayAccessExpression) {
            this._checkNoFunCall((ArrayAccessExpression)a, source);
            return;
        }
        if (a != null) {
            this._checkNoFunCall(a, source);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a, source).toString());
    }

    public void checkRHS1(EObject source, EObject e) {
        if (e instanceof ReferenceExpression) {
            this._checkRHS1(source, (ReferenceExpression)e);
            return;
        }
        if (e != null) {
            this._checkRHS1(source, e);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(source, e).toString());
    }

    public Integer maxRefCount(Object s) {
        if (s instanceof AnonymousProductType) {
            return this._maxRefCount((AnonymousProductType)s);
        }
        if (s instanceof NamedProductType) {
            return this._maxRefCount((NamedProductType)s);
        }
        if (s instanceof StructureType) {
            return this._maxRefCount((StructureType)s);
        }
        if (s instanceof TypeSpecifier) {
            return this._maxRefCount((TypeSpecifier)s);
        }
        if (s == null) {
            return this._maxRefCount((Void)null);
        }
        if (s != null) {
            return this._maxRefCount(s);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s).toString());
    }

    public Triple<Integer, Boolean, List<EObject>> innerMostReferences(EObject e) {
        if (e instanceof ElementReferenceExpression) {
            return this._innerMostReferences((ElementReferenceExpression)e);
        }
        if (e instanceof FeatureCall) {
            return this._innerMostReferences((FeatureCall)e);
        }
        if (e instanceof FunctionParameterDeclaration) {
            return this._innerMostReferences((FunctionParameterDeclaration)e);
        }
        if (e instanceof DereferenceExpression) {
            return this._innerMostReferences((DereferenceExpression)e);
        }
        if (e != null) {
            return this._innerMostReferences(e);
        }
        if (e == null) {
            return this._innerMostReferences((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public Optional<Pair<Integer, TypeSpecifier>> structuralFeatureContainsRefRefs(EObject s) {
        if (s instanceof AnonymousProductType) {
            return this._structuralFeatureContainsRefRefs((AnonymousProductType)s);
        }
        if (s instanceof NamedProductType) {
            return this._structuralFeatureContainsRefRefs((NamedProductType)s);
        }
        if (s instanceof StructureType) {
            return this._structuralFeatureContainsRefRefs((StructureType)s);
        }
        if (s != null) {
            return this._structuralFeatureContainsRefRefs(s);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s).toString());
    }
}

