/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.validation;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.HasAccessors;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Singleton;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypesFactory;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.base.types.validation.TypeValidator;
import org.eclipse.mita.base.util.BaseUtils;
import org.eclipse.mita.program.IsAssignmentCase;
import org.eclipse.mita.program.IsDeconstructionCase;
import org.eclipse.mita.program.IsDeconstructor;
import org.eclipse.mita.program.IsOtherCase;
import org.eclipse.mita.program.WhereIsStatement;
import org.eclipse.mita.program.inferrer.ProgramDslTypeInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SumTypesValidator
extends AbstractDeclarativeValidator
implements IValidationIssueAcceptor {
    @Inject
    private ProgramDslTypeInferrer inferrer;
    @Inject
    private TypeValidator validator;
    public static final String CANT_USE_BOTH_NAMED_AND_ANONYMOUS_DECONSTRUCTORS_MSG = "Deconstruction cases must not mix named and anonymous deconstructors";
    public static final String CANT_DECONSTRUCT_SINGLETONS_MSG = "Can't deconstruct singletons";
    public static final String CANT_ASSIGN_SINGLETONS_MSG = "Can't assign singletons";
    public static final String DEFAULT_CASE_MUST_BE_LAST_CASE_MSG = "Default case must be the last case";
    public static final String ERROR_WRONG_NUMBER_OF_DECONSTRUCTORS_MSG = "Wrong number of deconstructors, expected %s.";

    @Check(value=CheckType.FAST)
    public void checkIsDeconstructionCaseHasOnlyOneTypeOfDeconstructor(IsDeconstructionCase deconstructionCase) {
        Functions.Function1<IsDeconstructor, Boolean> _function = new Functions.Function1<IsDeconstructor, Boolean>(){

            public Boolean apply(IsDeconstructor it) {
                Parameter _productMember = it.getProductMember();
                return _productMember != null;
            }
        };
        List namedConstructor = ListExtensions.map(deconstructionCase.getDeconstructors(), (Functions.Function1)_function);
        boolean _containsAll = namedConstructor.containsAll(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{true, false})));
        if (_containsAll) {
            this.error(CANT_USE_BOTH_NAMED_AND_ANONYMOUS_DECONSTRUCTORS_MSG, deconstructionCase, null);
        }
    }

    @Check
    public void checkIsOtherCaseIsLastCase(IsOtherCase otherCase) {
        int _length;
        int _minus;
        boolean _notEquals;
        EObject _eContainer = otherCase.eContainer();
        WhereIsStatement whereIsStatement = (WhereIsStatement)_eContainer;
        int _indexOf = whereIsStatement.getIsCases().indexOf((Object)otherCase);
        boolean bl = _notEquals = _indexOf != (_minus = (_length = ((Object[])Conversions.unwrapArray(whereIsStatement.getIsCases(), Object.class)).length) - 1);
        if (_notEquals) {
            this.error(DEFAULT_CASE_MUST_BE_LAST_CASE_MSG, otherCase, null);
        }
    }

    @Check
    public void checkDeconstructorsHaveCorrectNumberOfArguments(IsDeconstructionCase deconstructionCase) {
        Type realType = deconstructionCase.getProductType().realType();
        Boolean _isAnonymous = deconstructionCase.isAnonymous();
        if (_isAnonymous.booleanValue()) {
            boolean _greaterThan;
            Object _xifexpression = null;
            _xifexpression = realType instanceof HasAccessors ? ((HasAccessors)realType).accessorsTypes() : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Type[]{realType}));
            EList fieldsTypes = _xifexpression;
            int _length = ((Object[])Conversions.unwrapArray(deconstructionCase.getDeconstructors(), Object.class)).length;
            int _length_1 = ((Object[])Conversions.unwrapArray((Object)fieldsTypes, Object.class)).length;
            boolean bl = _greaterThan = _length > _length_1;
            if (_greaterThan) {
                this.error(String.format(ERROR_WRONG_NUMBER_OF_DECONSTRUCTORS_MSG, ((Object[])Conversions.unwrapArray((Object)fieldsTypes, Object.class)).length), deconstructionCase, null);
                return;
            }
        }
    }

    @Check
    public void checkSumAlternativeConstructorsHaveCorrectArgumentsForFeatureCall(FeatureCall fc) {
        EObject ref = fc.getFeature();
        if (ref instanceof SumAlternative) {
            this.checkSumAlternativeConstructorsHaveCorrectArguments((EObject)fc, (EList<Argument>)fc.getArguments(), (SumAlternative)ref);
        }
    }

    @Check
    public void checkSumAlternativeConstructorsHaveCorrectArgumentsForERef(ElementReferenceExpression eref) {
        EObject ref = eref.getReference();
        if (ref instanceof SumAlternative) {
            this.checkSumAlternativeConstructorsHaveCorrectArguments((EObject)eref, (EList<Argument>)eref.getArguments(), (SumAlternative)ref);
        }
    }

    public void checkSumAlternativeConstructorsHaveCorrectArguments(EObject obj, EList<Argument> arguments, SumAlternative ref) {
        block12: {
            boolean _notEquals_1;
            EList realArgs;
            Type realType;
            block11: {
                boolean _notEquals;
                realType = ref.realType();
                Object _xifexpression = null;
                if (realType instanceof HasAccessors) {
                    _xifexpression = ((HasAccessors)realType).accessorsTypes();
                } else {
                    TypeSpecifier _createTypeSpecifier = TypesFactory.eINSTANCE.createTypeSpecifier();
                    Procedures.Procedure1<TypeSpecifier> _function = new Procedures.Procedure1<TypeSpecifier>(){

                        public void apply(TypeSpecifier it) {
                            it.setType(realType);
                        }
                    };
                    TypeSpecifier _doubleArrow = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function);
                    _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeSpecifier[]{_doubleArrow}));
                }
                realArgs = _xifexpression;
                int _length = ((Object[])Conversions.unwrapArray((Object)realArgs, Object.class)).length;
                int _length_1 = ((Object[])Conversions.unwrapArray(arguments, Object.class)).length;
                boolean bl = _notEquals = _length != _length_1;
                if (_notEquals) {
                    this.error(String.format("Wrong number of arguments, expected %s.", realArgs.toString()), obj, null);
                    return;
                }
                if (!(ref instanceof NamedProductType)) break block11;
                Iterable<Argument> argsSorted = ModelUtils.getSortedArguments((Iterable<Parameter>)((NamedProductType)ref).getParameters(), arguments);
                Iterable _zip = BaseUtils.zip(argsSorted, (Iterable)realArgs);
                for (Pair arg_type : _zip) {
                    final Expression sArg = ((Argument)arg_type.getKey()).getValue();
                    TypeSpecifier sField = (TypeSpecifier)arg_type.getValue();
                    ITypeSystemInferrer.InferenceResult t1 = this.inferrer.infer((EObject)sField, this);
                    ITypeSystemInferrer.InferenceResult t2 = this.inferrer.infer((EObject)sArg, this);
                    IValidationIssueAcceptor _function_1 = new IValidationIssueAcceptor(){

                        public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
                            SumTypesValidator.this.error(issue.getMessage(), (EObject)sArg, null);
                        }
                    };
                    this.validator.assertAssignable(t1, t2, String.format("Incompatible types: '%s' can't be converted to '%s'.", t2, t1), _function_1);
                }
                break block12;
            }
            if (!(ref instanceof AnonymousProductType)) break block12;
            Object _xifexpression_1 = null;
            if (realType instanceof StructureType) {
                Functions.Function1<Parameter, TypeSpecifier> _function_1 = new Functions.Function1<Parameter, TypeSpecifier>(){

                    public TypeSpecifier apply(Parameter it) {
                        return it.getTypeSpecifier();
                    }
                };
                _xifexpression_1 = ListExtensions.map((List)((StructureType)realType).getParameters(), (Functions.Function1)_function_1);
            } else {
                _xifexpression_1 = ((AnonymousProductType)ref).getTypeSpecifiers();
            }
            EList realTypeSpecifiers = _xifexpression_1;
            int _length_2 = ((Object[])Conversions.unwrapArray((Object)realTypeSpecifiers, Object.class)).length;
            int _length_3 = ((Object[])Conversions.unwrapArray(arguments, Object.class)).length;
            boolean bl = _notEquals_1 = _length_2 != _length_3;
            if (_notEquals_1) {
                Functions.Function1<TypeSpecifier, Type> _function_2 = new Functions.Function1<TypeSpecifier, Type>(){

                    public Type apply(TypeSpecifier it) {
                        return it.getType();
                    }
                };
                this.error(String.format("Wrong number of arguments, expected %s.", ListExtensions.map((List)realTypeSpecifiers, (Functions.Function1)_function_2).toString()), obj, null);
                return;
            }
            if (realType instanceof StructureType) {
                Iterable<Argument> argsSorted_1 = ModelUtils.getSortedArguments((Iterable<Parameter>)((StructureType)realType).getParameters(), arguments);
                Iterable _zip_1 = BaseUtils.zip(argsSorted_1, (Iterable)realArgs);
                for (Pair arg_type_1 : _zip_1) {
                    final Expression sArg = ((Argument)arg_type_1.getKey()).getValue();
                    TypeSpecifier sField = (TypeSpecifier)arg_type_1.getValue();
                    ITypeSystemInferrer.InferenceResult t1 = this.inferrer.infer((EObject)sField, this);
                    ITypeSystemInferrer.InferenceResult t2 = this.inferrer.infer((EObject)sArg, this);
                    IValidationIssueAcceptor _function_3 = new IValidationIssueAcceptor(){

                        public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
                            SumTypesValidator.this.error(issue.getMessage(), (EObject)sArg, null);
                        }
                    };
                    this.validator.assertAssignable(t1, t2, String.format("Incompatible types: '%s' can't be converted to '%s'.", t2, t1), _function_3);
                }
            } else {
                int i = 0;
                while (i < ((Object[])Conversions.unwrapArray((Object)realTypeSpecifiers, Object.class)).length) {
                    TypeSpecifier sField = (TypeSpecifier)realTypeSpecifiers.get(i);
                    final Expression sArg = ((Argument)arguments.get(i)).getValue();
                    ITypeSystemInferrer.InferenceResult t1 = this.inferrer.infer((EObject)sField, this);
                    ITypeSystemInferrer.InferenceResult t2 = this.inferrer.infer((EObject)sArg, this);
                    IValidationIssueAcceptor _function_3 = new IValidationIssueAcceptor(){

                        public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
                            SumTypesValidator.this.error(issue.getMessage(), (EObject)sArg, null);
                        }
                    };
                    this.validator.assertAssignable(t1, t2, String.format("Incompatible types: '%s' can't be converted to '%s'.", t2, t1), _function_3);
                    ++i;
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkIsAssignmentCaseCantAssignSingletons(IsAssignmentCase assignmentCase) {
        Type _type = assignmentCase.getAssignmentVariable().getTypeSpecifier().getType();
        if (_type instanceof Singleton) {
            this.error(CANT_ASSIGN_SINGLETONS_MSG, assignmentCase.getAssignmentVariable(), null);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkIsDeconstructionCaseCantDestructSingletons(IsDeconstructionCase deconstructionCase) {
        SumAlternative _productType = deconstructionCase.getProductType();
        if (_productType instanceof Singleton) {
            this.error(CANT_DECONSTRUCT_SINGLETONS_MSG, deconstructionCase, null);
        }
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }

    public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
        this.error(issue.getMessage(), issue.getTarget(), null);
    }
}

