/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xtend.typesystem.xsd.builder.OawXSDResource;
import org.eclipse.xtend.typesystem.xsd.builder.XSDManager;
import org.eclipse.xtend.typesystem.xsd.builder.XSDResolverFactory;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawXSDResourceSet
extends ResourceSetImpl
implements XSDManager {
    private static int counter = 0;
    protected ExtendedMetaData extendedMetadata;
    private int id = counter++;
    protected Log log = XSDLog.getLog(this.getClass());

    public OawXSDResourceSet() {
        this.extendedMetadata = new BasicExtendedMetaData(this.getPackageRegistry());
        this.getAdapterFactories().add((Object)new XSDResolverFactory());
        this.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        this.getLoadOptions().put("EXTENDED_META_DATA", this.extendedMetadata);
        Map extMap = this.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extMap.put("wsdl", new OawXSDResource.OawXSDResourceFactory());
        extMap.put("xsd", new OawXSDResource.OawXSDResourceFactory());
        extMap.put("ecore", new EcoreResourceFactoryImpl());
    }

    @Override
    public void clear() {
        for (Resource r : this.getResources()) {
            if (!r.isLoaded()) continue;
            r.unload();
        }
        this.getResources().clear();
    }

    public OawXSDResource createXsdResource(URI uri) {
        return (OawXSDResource)super.createResource(uri);
    }

    public int getID() {
        return this.id;
    }

    @Override
    public List<EPackage> getPackages() {
        ArrayList<EPackage> l = new ArrayList<EPackage>();
        for (Resource r : this.getResources()) {
            OawXSDResource x;
            if (!(r instanceof Resource) || !(x = (OawXSDResource)r).isEcorePackageGenerated()) continue;
            l.add(x.getEPackage());
        }
        return l;
    }

    public Set<EPackage> getPackages(Collection<URI> uris) {
        HashSet<EPackage> s = new HashSet<EPackage>();
        HashSet<OawXSDResource> o = new HashSet<OawXSDResource>();
        for (URI u : uris) {
            Resource r = this.getResource(u, false);
            if (!(r instanceof OawXSDResource)) continue;
            ((OawXSDResource)r).collectPackages(s, o);
        }
        return s;
    }

    public List<XSDSchema> getSchemas() {
        ArrayList<XSDSchema> a = new ArrayList<XSDSchema>();
        for (Resource r : this.getResources()) {
            OawXSDResource xr;
            if (!(r instanceof OawXSDResource) || (xr = (OawXSDResource)r).getSchema() == null) continue;
            a.add(xr.getSchema());
        }
        return a;
    }

    public OawXSDResource getXsdResource(URI uri, boolean loadOnDemand) {
        return (OawXSDResource)super.getResource(uri, loadOnDemand);
    }

    @Override
    public boolean hasErrors() {
        for (Resource r : this.getResources()) {
            if (r.getErrors().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getPackages().isEmpty();
    }

    @Override
    public void loadAndGenerate(URI uri) {
        OawXSDResource res = this.getXsdResource(uri, true);
        res.generateECore();
    }

    @Override
    public void markDirty(URI uri) {
        Resource r = this.getResource(uri, false);
        if (r == null) {
            r = this.createResource(uri);
        }
        OawXSDResource xr = (OawXSDResource)r;
        this.log.info((Object)Msg.create("Marking dirty: ").uri(uri));
        xr.markFileDirty();
        xr.setGeneratePackage(true);
    }

    @Override
    public void registerPackage(EPackage pkg) {
        this.getPackageRegistry().put((Object)pkg.getNsURI(), (Object)pkg);
    }

    @Override
    public void reloadDirty(ProgressMonitor pm) {
        this.log.info((Object)"Reloading all dirty");
        this.reloadSchemasWithDirtyFiles(pm);
        this.reloadEPackagesWithDirtySchemas(pm);
    }

    private void reloadEPackagesWithDirtySchemas(ProgressMonitor pm) {
        ArrayList<OawXSDResource> l = new ArrayList<OawXSDResource>();
        for (Resource resource : this.getResources()) {
            OawXSDResource xr;
            if (!(resource instanceof OawXSDResource) || !(xr = (OawXSDResource)resource).isSchemaDirty()) continue;
            l.add(xr);
        }
        for (OawXSDResource oawXSDResource : l) {
            if (!oawXSDResource.isEcorePackageGenerated() || pm.isCanceled()) continue;
            oawXSDResource.unloadPackage();
        }
        for (OawXSDResource oawXSDResource : l) {
            if (!oawXSDResource.isGeneratePackage() || !oawXSDResource.isSchemaDirty() || pm.isCanceled()) continue;
            pm.subTask("generating EPackage for " + oawXSDResource.getURI().lastSegment());
            oawXSDResource.generateECore();
            pm.worked(2);
        }
        pm.done();
    }

    private void reloadSchemasWithDirtyFiles(ProgressMonitor pm) {
        ArrayList<OawXSDResource> l = new ArrayList<OawXSDResource>();
        for (Resource resource : this.getResources()) {
            OawXSDResource xr;
            if (!(resource instanceof OawXSDResource) || !(xr = (OawXSDResource)resource).isFileDirty() && xr.isLoaded()) continue;
            l.add(xr);
        }
        pm.beginTask("XSD Adapter", l.size() * 3 + 1);
        pm.subTask("unloading changed resources");
        for (OawXSDResource oawXSDResource : l) {
            if (!oawXSDResource.isLoaded() || pm.isCanceled()) continue;
            oawXSDResource.unload();
        }
        pm.worked(1);
        for (OawXSDResource oawXSDResource : l) {
            try {
                if (oawXSDResource.isLoaded() || pm.isCanceled()) continue;
                this.log.info((Object)Msg.create("Reloading ").uri(oawXSDResource.getURI()));
                pm.subTask("loading " + oawXSDResource.getURI().lastSegment());
                oawXSDResource.load(new HashMap());
                pm.worked(1);
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }
    }

    @Override
    public void remove(URI uri) {
        OawXSDResource r = this.getXsdResource(uri, false);
        if (r == null) {
            return;
        }
        r.markFileDirty();
        this.log.info((Object)Msg.create("Removing ").uri(uri).txt(" from ").scls(this));
        r.unload();
        this.getResources().remove((Object)r);
    }

    public String toString() {
        ArrayList<String> i = new ArrayList<String>();
        for (EPackage pkg : this.getPackages()) {
            if (pkg != null) {
                i.add(pkg.getName());
                continue;
            }
            i.add("(null!)");
        }
        return String.valueOf(this.getClass().getSimpleName()) + this.id + i.toString();
    }

    @Override
    public void unregisterPackage(EPackage pkg) {
        this.getPackageRegistry().remove((Object)pkg.getNsURI());
    }
}

