/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;

public abstract class OTQualifiedAllocationExpression
extends QualifiedAllocationExpression.AbstractQualifiedAllocationExpression {
    private MessageSend creatorCall = null;
    private Runnable preGenerateTask = null;

    public OTQualifiedAllocationExpression(TypeDeclaration anonymousType) {
        super(anonymousType);
    }

    public OTQualifiedAllocationExpression() {
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.creatorCall == null) {
            return super.analyseCode(currentScope, flowContext, flowInfo);
        }
        return this.creatorCall.analyseCode(currentScope, flowContext, flowInfo);
    }

    @Override
    public Expression enclosingInstance() {
        return super.enclosingInstance();
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.preGenerateTask != null) {
            this.preGenerateTask.run();
        }
        if (this.creatorCall == null) {
            super.generateCode(currentScope, codeStream, valueRequired);
        } else {
            this.creatorCall.generateCode(currentScope, codeStream, valueRequired);
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        if (this.anonymousType == null && this.creatorCall == null && this.enclosingInstance == null) {
            return super.resolveType(scope);
        }
        this.constant = Constant.NotAConstant;
        CompilationResult compilationResult = scope.referenceContext().compilationResult();
        compilationResult.getCheckPoint(scope.referenceContext());
        this.hasEnclosingInstanceProblem = false;
        if (this.anonymousType == null && this.creatorCall == null) {
            TypeBinding enclosingInstanceType;
            if (this.enclosingInstance instanceof CastExpression) {
                this.enclosingInstance.bits |= 0x20;
            }
            boolean bl = this.hasEnclosingInstanceProblem = (enclosingInstanceType = this.enclosingInstance.resolveType(scope)) == null;
            if (!scope.isGeneratedScope() && enclosingInstanceType != null && enclosingInstanceType.isTeam()) {
                if (this.enclosingInstance instanceof NameReference) {
                    final NameReference anchorRef = (NameReference)this.enclosingInstance;
                    if (!((VariableBinding)anchorRef.binding).isFinal()) {
                        char[] variableName = ((VariableBinding)anchorRef.binding).name;
                        switch (anchorRef.bits & 7) {
                            case 2: {
                                final LocalVariableBinding localOrig = (LocalVariableBinding)anchorRef.binding;
                                localOrig.useFlag = 1;
                                anchorRef.binding = new LocalVariableBinding(variableName, enclosingInstanceType, 16, false){

                                    @Override
                                    public int problemId() {
                                        return 1102209;
                                    }
                                };
                                this.preGenerateTask = new Runnable(){

                                    @Override
                                    public void run() {
                                        ((LocalVariableBinding)anchorRef.binding).resolvedPosition = localOrig.resolvedPosition;
                                    }
                                };
                                break;
                            }
                            case 1: {
                                anchorRef.binding = new FieldBinding(variableName, enclosingInstanceType, 16, scope.referenceType().binding, Constant.NotAConstant){

                                    @Override
                                    public int problemId() {
                                        return 1102209;
                                    }
                                };
                                break;
                            }
                            default: {
                                throw new InternalCompilerError("Unexpected bits, neither local nor field " + anchorRef.bits + ": " + anchorRef);
                            }
                        }
                    }
                }
                if (this.type.getTypeName().length > 1) {
                    scope.problemReporter().roleCreationNotRelativeToEnclosingTeam(this);
                    return null;
                }
                this.creatorCall = CopyInheritance.createConstructorMethodInvocationExpression(scope, this);
                if (this.creatorCall == null) {
                    return null;
                }
            }
        }
        if (this.creatorCall == null) {
            this.resolvedType = super.resolveType(scope);
            if (!this.hasEnclosingInstanceProblem) {
                RoleTypeBinding superRole;
                TypeBinding enclosingType;
                if (this.enclosingInstance != null && (enclosingType = this.enclosingInstance.resolvedType) instanceof ReferenceBinding && ((ReferenceBinding)enclosingType).isDirectRole()) {
                    this.enclosingInstanceCast = ((ReferenceBinding)enclosingType).getRealClass();
                }
                ReferenceBinding superType = null;
                if (this.resolvedType instanceof ReferenceBinding) {
                    superType = ((ReferenceBinding)this.resolvedType).superclass();
                }
                if (superType != null && superType instanceof RoleTypeBinding && (superRole = (RoleTypeBinding)superType).hasExplicitAnchor()) {
                    scope.problemReporter().extendingExternalizedRole(superRole, this.type);
                }
            }
        } else {
            this.resolvedType = this.creatorCall.resolveType(scope);
            if (this.resolvedType != null) {
                if (((ReferenceBinding)this.resolvedType).isAbstract() && !((ReferenceBinding)this.enclosingInstance().resolvedType).isAbstract()) {
                    scope.problemReporter().abstractRoleIsRelevant(this, (ReferenceBinding)this.creatorCall.resolvedType);
                }
                if (this.resolvedType.isValidBinding()) {
                    MethodBinding ctor;
                    Expression createExpr = this.creatorCall;
                    while (createExpr instanceof CastExpression) {
                        createExpr = ((CastExpression)createExpr).expression;
                    }
                    this.binding = createExpr.binding;
                    ReferenceBinding role = (ReferenceBinding)this.resolvedType;
                    MethodBinding creator = this.binding;
                    if (creator != null && Lifting.isLiftToConstructor(ctor = role.getExactConstructor(creator.parameters), role)) {
                        scope.problemReporter().qualifiedUseOfLiftingConstructor(ctor, this.creatorCall);
                    }
                }
            }
        }
        return this.resolvedType;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.creatorCall == null) {
            return super.printExpression(indent, output);
        }
        return this.creatorCall.printExpression(indent, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (this.creatorCall == null) {
            super.traverse(visitor, scope);
        } else {
            this.creatorCall.traverse(visitor, scope);
        }
    }

    public MethodBinding getMethodBinding() {
        if (this.creatorCall != null) {
            return this.creatorCall.binding;
        }
        return this.binding;
    }
}

