/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.ExtraCompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TSuperMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.IProtectable;

public class Protections
implements ClassFileConstants,
ExtraCompilerModifiers {
    private static final int AccSynthIfc = 4608;

    public static int checkRoleModifiers(int modifiers, TypeDeclaration type, Scope scope) {
        if (!type.isSourceRole()) {
            return modifiers;
        }
        if ((modifiers & 2) != 0) {
            modifiers ^= 2;
            if (!Protections.hasClassKindProblem(type.binding)) {
                scope.problemReporter().illegalModifierForRole(type.binding);
            }
        } else if ((modifiers & 5) == 0) {
            modifiers |= 4;
            if (!Protections.hasClassKindProblem(type.binding)) {
                scope.problemReporter().illegalModifierForRole(type.binding);
            }
        }
        if ((modifiers & 0x8000) == 0 && type.memberTypes != null && type.memberTypes.length > 0) {
            if (!Protections.hasClassKindProblem(type.binding)) {
                scope.problemReporter().missingTeamForRoleWithMembers(type.binding, type.memberTypes[0]);
            }
            if (!type.isInterface()) {
                modifiers |= 0x8000;
                type.modifiers |= 0x8000;
            }
            type.getTeamModel().tagBits |= 0x400;
            int i = 0;
            while (i < type.memberTypes.length) {
                type.memberTypes[i].modifiers |= 0x1000000;
                type.memberTypes[i].enclosingType = type;
                RoleModel roleModel = type.memberTypes[i].getRoleModel();
                if (!type.memberTypes[i].isRoleFile()) {
                    roleModel.setState(1);
                }
                Dependencies.ensureRoleState(roleModel, 2);
                ++i;
            }
        }
        if ((modifiers & 8) != 0 && (modifiers & 0x1000000) != 0 && !Protections.hasClassKindProblem(type.binding)) {
            scope.problemReporter().staticRole(type.binding);
        }
        return modifiers;
    }

    public static boolean hasClassKindProblem(ReferenceBinding binding) {
        TeamModel model = binding._teamModel;
        if (model != null && (model.tagBits & 0x400) != 0) {
            return true;
        }
        if (binding.enclosingType() != null) {
            return Protections.hasClassKindProblem(binding.enclosingType());
        }
        return false;
    }

    public static boolean isRoleInterfaceMethod(MethodBinding inheritedMethod) {
        int classModifiers = inheritedMethod.declaringClass.modifiers;
        return (classModifiers & 0x1200) == 4608;
    }

    public static boolean checkRoleIfcVisibility(int modifiers, MethodBinding[] abstractMethods) {
        int i = 0;
        while (i < abstractMethods.length) {
            MethodModel model = abstractMethods[i].model;
            if (model == null || model.problemDetail != MethodModel.ProblemDetail.RoleInheritsNonPublic) {
                ReferenceBinding ifc = abstractMethods[i].declaringClass;
                if ((ifc.modifiers & 0x1200) != 4608) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean isAsVisible(int modifiers, int inheritedModifiers) {
        if ((inheritedModifiers & 7) == (modifiers & 7)) {
            return true;
        }
        if ((modifiers & 1) != 0) {
            return true;
        }
        if ((inheritedModifiers & 1) != 0) {
            return false;
        }
        if ((modifiers & 4) != 0) {
            return true;
        }
        if ((inheritedModifiers & 4) != 0) {
            return false;
        }
        return (modifiers & 2) == 0;
    }

    public static String toString(int modifiers) {
        if ((modifiers & 1) != 0) {
            return "public";
        }
        if ((modifiers & 4) != 0) {
            return "protected";
        }
        if ((modifiers & 2) != 0) {
            return "private";
        }
        return "<default visibility>";
    }

    public static int combine(int classMod, int featureMod) {
        int abstractness = classMod & 0x400 | featureMod & 0x400;
        int visibility = 0;
        if ((featureMod & 2) != 0) {
            throw new InternalCompilerError("precond violated");
        }
        visibility = (classMod & 2) != 0 ? classMod & 7 : ((classMod & 7) == 0 ? 0 : ((classMod & 4) != 0 ? ((featureMod & 5) != 0 ? 4 : 0) : featureMod & 7));
        return visibility | abstractness;
    }

    public static boolean findSuperIfcInPackage(ReferenceBinding startType, ReferenceBinding requiredType, PackageBinding requiredPackage) {
        if (startType.fPackage != requiredPackage) {
            return false;
        }
        if (TypeBinding.equalsEquals(startType, requiredType)) {
            return true;
        }
        ReferenceBinding[] superIfcs = startType.superInterfaces();
        if (superIfcs == null) {
            return false;
        }
        int i = 0;
        while (i < superIfcs.length) {
            if (Protections.findSuperIfcInPackage(superIfcs[i], requiredType, requiredPackage)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean checkCompatibleEnclosingForRoles(Scope scope, TypeDeclaration clazz, SourceTypeBinding binding, ReferenceBinding other) {
        ReferenceBinding otherEnclosing;
        if (!binding.isRole()) {
            return true;
        }
        if (binding.isTeam()) {
            ReferenceBinding enclosing = binding.enclosingType();
            while (enclosing != null) {
                if (TypeBinding.equalsEquals(enclosing, other)) {
                    scope.problemReporter().teamExtendingEnclosing(clazz, other);
                    return false;
                }
                enclosing = enclosing.enclosingType();
            }
        }
        if ((otherEnclosing = other.original().enclosingType()) == null) {
            return true;
        }
        ReferenceBinding thisEnclosing = binding.enclosingType();
        while (thisEnclosing != null) {
            if (thisEnclosing.isCompatibleWith(otherEnclosing)) {
                return true;
            }
            thisEnclosing = thisEnclosing.enclosingType();
        }
        scope.problemReporter().extendIncompatibleEnclosingTypes(clazz, other, otherEnclosing);
        return false;
    }

    public static boolean canBeSeenBy(IProtectable binding, TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (RoleTypeBinding.isRoleWithExplicitAnchor(receiverType)) {
            return false;
        }
        if ((binding.modifiers() & Integer.MIN_VALUE) != 0) {
            return true;
        }
        ReferenceBinding declaringClass = (ReferenceBinding)binding.getDeclaringClass().getRealClass().erasure();
        ReferenceBinding invocationType = scope.enclosingSourceType();
        if (invocationSite instanceof TSuperMessageSend && invocationType.isRole() && invocationType.roleModel.hasTSuperRole(declaringClass)) {
            return true;
        }
        if (binding.isProtected()) {
            if (TypeBinding.equalsEquals(invocationType, declaringClass)) {
                return true;
            }
            if (receiverType instanceof ReferenceBinding) {
                ReferenceBinding receiver = (ReferenceBinding)receiverType;
                declaringClass = (ReferenceBinding)TeamModel.strengthenRoleType(receiver, declaringClass);
                if (invocationType.isRole()) {
                    invocationType = (ReferenceBinding)TeamModel.strengthenRoleType(receiver, invocationType);
                }
            }
            ReferenceBinding currentType = invocationType;
            int depth = 0;
            do {
                if (TeamModel.isTeamContainingRole(currentType, declaringClass)) {
                    return true;
                }
                if (declaringClass.isSuperclassOf(currentType)) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (binding.isStatic()) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                    if (TypeBinding.equalsEquals(currentType, receiverType) || currentType.isSuperclassOf((ReferenceBinding)receiverType)) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        ReferenceBinding currentInvocationType = invocationType;
        while (currentInvocationType != null) {
            if (TypeBinding.equalsEquals(currentInvocationType, declaringClass)) {
                return true;
            }
            currentInvocationType = currentInvocationType.enclosingType();
        }
        if (binding.isPrivate()) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        if (invocationSite.isSuperAccess()) {
            invocationType = ((ReferenceBinding)invocationType).superclass();
        }
        ReferenceBinding currentType = (ReferenceBinding)(invocationType.isInterface() ? ((ReferenceBinding)receiverType).getRealType().erasure() : ((ReferenceBinding)receiverType).getRealClass().erasure());
        PackageBinding declaringPackage = declaringClass.fPackage;
        do {
            if (TypeBinding.equalsEquals(invocationType, currentType)) {
                return true;
            }
            if (currentType.isRole() || declaringPackage == currentType.fPackage) continue;
            return false;
        } while ((currentType = currentType.superclass()) != null);
        return false;
    }
}

