/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.ui.DelegatingLabelDecorator;
import org.eclipse.oomph.ui.LabelDecorator;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PropertiesViewer
extends TableViewer {
    private TableColumn propertyColumn;
    private TableColumn valueColumn;
    private ControlAdapter columnResizer;
    private DelegatingLabelDecorator labelDecorator = new DelegatingLabelDecorator();

    public PropertiesViewer(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200 | 0x10000);
        final Table table = this.getTable();
        UIUtil.applyGridData((Control)table).heightHint = 64;
        this.setLabelProvider((IBaseLabelProvider)new DecoratingPropertiesLabelProvider(new PropertiesLabelProvider(), this.labelDecorator, (Control)table));
        this.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.propertyColumn = new TableColumn(table, 0);
        this.propertyColumn.setText("Property");
        this.propertyColumn.setWidth(200);
        this.propertyColumn.setResizable(false);
        this.valueColumn = new TableColumn(table, 0);
        this.valueColumn.setText("Value");
        this.valueColumn.setWidth(400);
        this.valueColumn.setResizable(false);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.columnResizer = new ControlAdapter(){
            private boolean resizing;

            public void controlResized(ControlEvent e) {
                if (!this.resizing) {
                    try {
                        table.setRedraw(false);
                        this.resizing = true;
                        Rectangle clientArea = table.getClientArea();
                        int clientWidth = clientArea.width - clientArea.x;
                        TableItem[] items = table.getItems();
                        if (items.length == 0) {
                            PropertiesViewer.this.propertyColumn.setWidth(clientWidth / 2);
                            PropertiesViewer.this.valueColumn.setWidth(clientWidth - clientWidth / 2);
                        } else {
                            PropertiesViewer.this.propertyColumn.pack();
                            int propertyColumnWidth = PropertiesViewer.this.propertyColumn.getWidth();
                            PropertiesViewer.this.propertyColumn.setWidth(propertyColumnWidth += 20);
                            PropertiesViewer.this.valueColumn.pack();
                            int valueColumnWidth = PropertiesViewer.this.valueColumn.getWidth();
                            if (propertyColumnWidth + valueColumnWidth < clientWidth) {
                                PropertiesViewer.this.valueColumn.setWidth(clientWidth - propertyColumnWidth);
                            }
                        }
                    }
                    finally {
                        table.setRedraw(true);
                        this.resizing = false;
                    }
                }
            }
        };
        table.addControlListener((ControlListener)this.columnResizer);
        UIUtil.asyncExec((Control)table, new Runnable(){

            public void run() {
                PropertiesViewer.this.columnResizer.controlResized(null);
            }
        });
    }

    public DelegatingLabelDecorator getDelegatingLabelDecorator() {
        return this.labelDecorator;
    }

    private final class DecoratingPropertiesLabelProvider
    extends DecoratingColumLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private PropertiesLabelProvider propertiesLabelProvider;
        private LabelDecorator labelDecorator;
        private Control control;

        public DecoratingPropertiesLabelProvider(PropertiesLabelProvider labelProvider, LabelDecorator labelDecorator, Control control) {
            super((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator);
            this.propertiesLabelProvider = labelProvider;
            this.labelDecorator = labelDecorator;
            this.control = control;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.propertiesLabelProvider.getColumnImage(element, columnIndex);
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.propertiesLabelProvider.getColumnText(element, columnIndex);
        }

        public Font getFont(Object element, int columnIndex) {
            return this.labelDecorator.decorateFont(this.control.getFont(), ((Object[])element)[4]);
        }

        public Color getForeground(Object element, int columnIndex) {
            return this.labelDecorator.decorateForeground(this.control.getForeground(), ((Object[])element)[4]);
        }

        public Color getBackground(Object element, int columnIndex) {
            return this.labelDecorator.decorateBackground(this.control.getBackground(), ((Object[])element)[4]);
        }
    }

    private final class PropertiesContentProvider
    implements IStructuredContentProvider {
        private final ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
        private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory);

        private PropertiesContentProvider() {
        }

        public void dispose() {
            this.adapterFactory.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            UIUtil.asyncExec(viewer.getControl(), new Runnable(){

                public void run() {
                    PropertiesViewer.this.columnResizer.controlResized(null);
                }
            });
        }

        public Object[] getElements(Object element) {
            ArrayList<Object> properties = new ArrayList<Object>();
            ArrayList<Object[]> expertProperties = new ArrayList<Object[]>();
            List propertyDescriptors = this.itemDelegator.getPropertyDescriptors(element);
            if (propertyDescriptors != null) {
                for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    Object object;
                    Object propertyValue;
                    String displayName = propertyDescriptor.getDisplayName(element);
                    IItemLabelProvider propertyLabelProvider = propertyDescriptor.getLabelProvider(element);
                    Object imageURL = propertyLabelProvider.getImage(propertyValue = this.itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(element)));
                    Image image = imageURL == null ? null : ExtendedImageRegistry.INSTANCE.getImage(imageURL);
                    String valueText = propertyLabelProvider.getText(propertyValue);
                    if (StringUtil.isEmpty((String)valueText)) {
                        valueText = "";
                    }
                    EStructuralFeature.Setting setting = null;
                    Object feature = propertyDescriptor.getFeature(element);
                    if (feature instanceof EStructuralFeature && (object = AdapterFactoryEditingDomain.unwrap((Object)element)) instanceof EObject) {
                        setting = ((InternalEObject)object).eSetting((EStructuralFeature)feature);
                    }
                    if (this.isExpertProperty(propertyDescriptor, element)) {
                        expertProperties.add(new Object[]{displayName, valueText, image, true, setting});
                        continue;
                    }
                    properties.add(new Object[]{displayName, valueText, image, false, setting});
                }
            }
            properties.addAll(expertProperties);
            return properties.toArray();
        }

        private boolean isExpertProperty(IItemPropertyDescriptor propertyDescriptor, Object element) {
            String[] filterFlags = propertyDescriptor.getFilterFlags(element);
            if (filterFlags != null) {
                String[] stringArray = filterFlags;
                int n = filterFlags.length;
                int n2 = 0;
                while (n2 < n) {
                    String filterFlag = stringArray[n2];
                    if (PropertiesUtil.EXPERT_FILTER[0].equals(filterFlag)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private final class PropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            return (String)((Object[])element)[columnIndex];
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return (Image)((Object[])element)[2];
            }
            return null;
        }
    }
}

