/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfProductCatalogURIHandlerImpl
extends URIHandlerImpl {
    public static final String SELF_PRODUCT_CATALOG_NAME = "self";
    private static final URI SELF_PRODUCT_CATALOG_URI = URI.createURI((String)"catalog:/self-product-catalog.setup");
    private static final String UNKNOWN_VERSION = "0.0.0";
    private static final Date NOW = new Date();

    public boolean canHandle(URI uri) {
        return "catalog".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        if (SELF_PRODUCT_CATALOG_URI.equals(uri)) {
            class ProductCatalogInput
            extends InputStream
            implements URIConverter.Loadable {
                private InputStream in;

                ProductCatalogInput() {
                }

                public void loadResource(Resource resource) throws IOException {
                    resource.getContents().add((Object)SelfProductCatalogURIHandlerImpl.this.create());
                }

                public int read() throws IOException {
                    if (this.in == null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(SELF_PRODUCT_CATALOG_URI).createResource(SELF_PRODUCT_CATALOG_URI);
                        resource.getContents().add((Object)SelfProductCatalogURIHandlerImpl.this.create());
                        resource.save((OutputStream)out, null);
                        this.in = new ByteArrayInputStream(out.toByteArray());
                    }
                    return this.in.read();
                }
            }
            return new ProductCatalogInput();
        }
        throw new IOException("No product catalog for " + uri);
    }

    private ProductCatalog create() {
        ProductCatalog productCatalog = SetupFactory.eINSTANCE.createProductCatalog();
        productCatalog.setName(SELF_PRODUCT_CATALOG_NAME);
        productCatalog.setLabel("<Self Products>");
        productCatalog.setDescription("The product catalog for the self product and the empty product");
        InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
        installationTask.setID("installation");
        productCatalog.getSetupTasks().add((Object)installationTask);
        Product selfProduct = SetupFactory.eINSTANCE.createProduct();
        selfProduct.setName("product");
        selfProduct.setLabel("Self");
        selfProduct.setDescription("The self product");
        productCatalog.getProducts().add((Object)selfProduct);
        VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
        variable.setName("installation.location");
        variable.setValue(SetupContext.PRODUCT_ROOT_LOCATION.toFileString());
        selfProduct.getSetupTasks().add((Object)variable);
        ProductVersion selfProductVersion = SetupFactory.eINSTANCE.createProductVersion();
        selfProductVersion.setName("version");
        selfProductVersion.setLabel(UNKNOWN_VERSION);
        selfProductVersion.setDescription("The self product version");
        selfProduct.getVersions().add((Object)selfProductVersion);
        try {
            IProduct product = Platform.getProduct();
            if (product != null) {
                Bundle bundle;
                String name = product.getName();
                if (!StringUtil.isEmpty((String)name)) {
                    selfProduct.setLabel(name);
                }
                if ((bundle = product.getDefiningBundle()) != null) {
                    selfProductVersion.setLabel(bundle.getVersion().toString());
                }
            }
        }
        catch (Throwable throwable) {}
        Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
        annotation.setSource("http://www.eclipse.org/oomph/setup/BrandingInfo");
        String folderName = SetupContext.PRODUCT_LOCATION.segmentCount() == 0 ? "" : URI.decode((String)SetupContext.PRODUCT_LOCATION.segment(SetupContext.PRODUCT_ROOT_LOCATION.segmentCount()));
        annotation.getDetails().put((Object)"folderName", (Object)folderName);
        selfProductVersion.getAnnotations().add((Object)annotation);
        P2Task selfP2Task = SetupP2Factory.eINSTANCE.createP2Task();
        selfProductVersion.getSetupTasks().add((Object)selfP2Task);
        try {
            IMetadataRepositoryManager metadataRepositoryManager;
            java.net.URI[] knownRepositories;
            IProvisioningAgent agent = P2Util.getCurrentProvisioningAgent();
            IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class.getName());
            IProfile profile = profileRegistry.getProfile("_SELF_");
            if (profile != null) {
                EList requirements = selfP2Task.getRequirements();
                IQueryResult query = profile.query(QueryUtil.createIUAnyQuery(), null);
                for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)query)) {
                    if (!"true".equals(profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.root"))) continue;
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                    Version version = iu.getVersion();
                    if (version.isOSGiCompatible()) {
                        org.osgi.framework.Version osgiVersion = new org.osgi.framework.Version(version.toString());
                        int major = osgiVersion.getMajor();
                        int minor = osgiVersion.getMinor();
                        VersionRange versionRange = new VersionRange(Version.createOSGi((int)major, (int)minor, (int)0), true, Version.createOSGi((int)major, (int)(minor + 1), (int)0), false);
                        requirement.setVersionRange(versionRange);
                    }
                    requirement.setName(iu.getId());
                    requirement.setMatchExpression(iu.getFilter());
                    requirements.add((Object)requirement);
                }
            }
            if ((knownRepositories = (metadataRepositoryManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME)).getKnownRepositories(2)).length > 0) {
                EList repositories = selfP2Task.getRepositories();
                java.net.URI[] uRIArray = knownRepositories;
                int n = knownRepositories.length;
                int n2 = 0;
                while (n2 < n) {
                    java.net.URI knownRepository = uRIArray[n2];
                    Repository repository = P2Factory.eINSTANCE.createRepository(knownRepository.toString());
                    repositories.add((Object)repository);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            SetupCorePlugin.INSTANCE.log(throwable, 2);
        }
        Product emptyProduct = SetupFactory.eINSTANCE.createProduct();
        emptyProduct.setName("empty.product");
        emptyProduct.setLabel("Empty");
        emptyProduct.setDescription("The empty product");
        productCatalog.getProducts().add((Object)emptyProduct);
        ProductVersion emptyProductVersion = SetupFactory.eINSTANCE.createProductVersion();
        emptyProductVersion.setName("version");
        emptyProductVersion.setLabel(UNKNOWN_VERSION);
        emptyProductVersion.setDescription("The empty product version");
        emptyProduct.getVersions().add((Object)emptyProductVersion);
        return productCatalog;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        throw new IOException("Can't write to " + uri);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        throw new IOException("Can't delete " + uri);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return true;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        HashMap<String, Comparable<Date>> result = new HashMap<String, Comparable<Date>>();
        Set requestedAttributes = this.getRequestedAttributes(options);
        if (requestedAttributes == null || requestedAttributes.contains("timeStamp")) {
            result.put("timeStamp", NOW);
        }
        if (requestedAttributes == null || requestedAttributes.contains("length")) {
            InputStream inputStream = null;
            try {
                inputStream = this.createInputStream(uri, options);
                result.put("length", Integer.valueOf(inputStream.available()));
            }
            catch (IOException iOException) {
                IOUtil.close(inputStream);
            }
        }
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", Boolean.TRUE);
        }
        if (requestedAttributes == null || requestedAttributes.contains("hidden")) {
            result.put("hidden", Boolean.FALSE);
        }
        if (requestedAttributes == null || requestedAttributes.contains("directory")) {
            result.put("directory", Boolean.FALSE);
        }
        return result;
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        throw new IOException("Can't set attributes for " + uri);
    }
}

