/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.FedXQueueCursor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.exception.ExceptionUtil;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParallelExecutorBase<T>
extends LookAheadIteration<T, QueryEvaluationException>
implements ParallelExecutor<T> {
    protected static final Logger log = LoggerFactory.getLogger(ParallelExecutorBase.class);
    protected static final AtomicLong NEXT_EXECUTOR_ID = new AtomicLong(0L);
    protected final FederationEvalStrategy strategy;
    protected final long executorId;
    protected final QueryInfo queryInfo;
    protected volatile Thread evaluationThread;
    protected FedXQueueCursor<T> rightQueue = FedXQueueCursor.create(1024);
    protected CloseableIteration<T, QueryEvaluationException> rightIter;
    protected volatile boolean closed;
    protected boolean finished = false;

    public ParallelExecutorBase(FederationEvalStrategy strategy, QueryInfo queryInfo) throws QueryEvaluationException {
        this.strategy = strategy;
        this.executorId = NEXT_EXECUTOR_ID.incrementAndGet();
        this.queryInfo = queryInfo;
    }

    @Override
    public final void run() {
        this.evaluationThread = Thread.currentThread();
        if (log.isTraceEnabled()) {
            log.trace("Performing execution of " + this.getDisplayId() + ", thread: " + this.evaluationThread.getName());
        }
        try {
            this.performExecution();
            this.checkTimeout();
        }
        catch (Throwable t) {
            this.toss(ExceptionUtil.toException(t));
        }
        finally {
            this.finished = true;
            this.evaluationThread = null;
            this.rightQueue.done();
        }
        if (log.isTraceEnabled()) {
            log.trace(this.getDisplayId() + " is finished.");
        }
    }

    protected abstract void performExecution() throws Exception;

    @Override
    public void addResult(CloseableIteration<T, QueryEvaluationException> res) {
        if (res instanceof EmptyIteration) {
            return;
        }
        try {
            this.rightQueue.put(res);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error adding element to right queue", e);
        }
    }

    @Override
    public void done() {
    }

    @Override
    public void toss(Exception e) {
        this.rightQueue.toss(e);
        if (log.isTraceEnabled()) {
            log.trace("Tossing exception of " + this.getDisplayId() + ": " + e.getMessage());
        }
    }

    @Override
    public T getNextElement() throws QueryEvaluationException {
        while (this.rightIter != null || this.rightQueue.hasNext()) {
            if (this.rightIter == null) {
                this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (this.rightIter.hasNext()) {
                return (T)this.rightIter.next();
            }
            this.rightIter.close();
            this.rightIter = null;
        }
        this.rightQueue.checkException();
        return null;
    }

    protected void checkTimeout() throws QueryInterruptedException {
        long maxTimeLeft = this.queryInfo.getMaxRemainingTimeMS();
        if (maxTimeLeft <= 0L) {
            throw new QueryInterruptedException("Query evaluation has run into a timeout");
        }
    }

    @Override
    public void handleClose() throws QueryEvaluationException {
        try {
            this.rightQueue.close();
        }
        finally {
            if (this.rightIter != null) {
                this.rightIter.close();
                this.rightIter = null;
            }
        }
        this.closed = true;
        super.handleClose();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    protected String getId() {
        return "#" + this.executorId + " (Query: " + this.queryInfo.getQueryID() + ")";
    }

    public String getDisplayId() {
        return this.getExecutorType() + " " + this.getId();
    }

    protected String getExecutorType() {
        return "Executor";
    }

    public String toString() {
        return this.getExecutorType() + " " + this.getClass().getSimpleName() + " {id: " + this.getId() + "}";
    }
}

