/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.config;

import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.config.SailRepositoryConfig;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.StackableSail;
import org.eclipse.rdf4j.sail.config.DelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.config.SailRegistry;

public class SailRepositoryFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "openrdf:SailRepository";

    @Override
    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    @Override
    public RepositoryImplConfig getConfig() {
        return new SailRepositoryConfig();
    }

    @Override
    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        if (config instanceof SailRepositoryConfig) {
            SailRepositoryConfig sailRepConfig = (SailRepositoryConfig)config;
            try {
                Sail sail = this.createSailStack(sailRepConfig.getSailImplConfig());
                return new SailRepository(sail);
            }
            catch (SailConfigException e) {
                throw new RepositoryConfigException(e.getMessage(), e);
            }
        }
        throw new RepositoryConfigException("Invalid configuration class: " + config.getClass());
    }

    private Sail createSailStack(SailImplConfig config) throws RepositoryConfigException, SailConfigException {
        SailImplConfig delegateConfig;
        Sail sail = this.createSail(config);
        if (config instanceof DelegatingSailImplConfig && (delegateConfig = ((DelegatingSailImplConfig)config).getDelegate()) != null) {
            this.addDelegate(delegateConfig, sail);
        }
        return sail;
    }

    private Sail createSail(SailImplConfig config) throws RepositoryConfigException, SailConfigException {
        SailFactory sailFactory = (SailFactory)SailRegistry.getInstance().get(config.getType()).orElseThrow(() -> new RepositoryConfigException("Unsupported Sail type: " + config.getType()));
        return sailFactory.getSail(config);
    }

    private void addDelegate(SailImplConfig config, Sail sail) throws RepositoryConfigException, SailConfigException {
        Sail delegateSail = this.createSailStack(config);
        try {
            ((StackableSail)sail).setBaseSail(delegateSail);
        }
        catch (ClassCastException e) {
            throw new RepositoryConfigException("Delegate configured but " + sail.getClass() + " is not a StackableSail");
        }
    }
}

