/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers;

import java.util.ArrayDeque;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.VariableScopeChange;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.explanation.GenericPlanNode;

@Experimental
@InternalUseOnly
public class QueryModelTreeToGenericPlanNode
extends AbstractQueryModelVisitor<RuntimeException> {
    GenericPlanNode top = null;
    QueryModelNode topTupleExpr;
    ArrayDeque<GenericPlanNode> deque = new ArrayDeque();

    public QueryModelTreeToGenericPlanNode(QueryModelNode topTupleExpr) {
        this.topTupleExpr = topTupleExpr;
    }

    public GenericPlanNode getGenericPlanNode() {
        return this.top;
    }

    @Override
    protected void meetNode(QueryModelNode node) {
        GenericPlanNode genericPlanNode = new GenericPlanNode(node.getSignature());
        genericPlanNode.setCostEstimate(node.getCostEstimate());
        genericPlanNode.setResultSizeEstimate(node.getResultSizeEstimate());
        genericPlanNode.setResultSizeActual(node.getResultSizeActual());
        if (node instanceof VariableScopeChange) {
            boolean newScope = ((VariableScopeChange)((Object)node)).isVariableScopeChange();
            genericPlanNode.setNewScope(newScope);
        }
        if (node instanceof BinaryTupleOperator) {
            String algorithmName = ((BinaryTupleOperator)node).getAlgorithmName();
            genericPlanNode.setAlgorithm(algorithmName);
        }
        genericPlanNode.setTotalTimeActual((double)node.getTotalTimeNanosActual() / 1000000.0);
        if (node == this.topTupleExpr) {
            this.top = genericPlanNode;
        }
        if (!this.deque.isEmpty()) {
            GenericPlanNode genericParentNode = this.deque.getLast();
            genericParentNode.addPlans(genericPlanNode);
        }
        this.deque.addLast(genericPlanNode);
        super.meetNode(node);
        this.deque.removeLast();
    }
}

