/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class GroupByCount
implements PlanNode {
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public GroupByCount(PlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<Tuple, SailException> parentIterator;
            Tuple tempNext;
            Tuple next;
            {
                this.parentIterator = GroupByCount.this.parent.iterator();
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.tempNext == null && this.parentIterator.hasNext()) {
                    this.tempNext = (Tuple)this.parentIterator.next();
                }
                if (this.tempNext == null) {
                    return;
                }
                long count = 0L;
                this.next = new Tuple();
                Value subject = this.tempNext.getLine().get(0);
                while (this.tempNext != null && (this.tempNext.getLine().get(0) == subject || this.tempNext.getLine().get(0).equals(subject))) {
                    this.next.addHistory(this.tempNext);
                    if (this.tempNext.getLine().size() > 1) {
                        ++count;
                    }
                    if (this.parentIterator.hasNext()) {
                        this.tempNext = (Tuple)this.parentIterator.next();
                        continue;
                    }
                    this.tempNext = null;
                }
                ArrayList<Value> line = new ArrayList<Value>(Arrays.asList(subject, SimpleValueFactory.getInstance().createLiteral(count)));
                this.next.setLine(line);
            }

            @Override
            public void close() throws SailException {
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            Tuple loggingNext() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "GroupByCount";
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return IteratorData.aggregated;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }
}

