/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.IOException;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.nativerdf.ValueStore;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeValue;

class NativeStatementIterator
extends LookAheadIteration<Statement, SailException> {
    private final RecordIterator btreeIter;
    private final ValueStore valueStore;

    public NativeStatementIterator(RecordIterator btreeIter, ValueStore valueStore) throws IOException {
        this.btreeIter = btreeIter;
        this.valueStore = valueStore;
    }

    @Override
    public Statement getNextElement() throws SailException {
        try {
            byte[] nextValue = this.btreeIter.next();
            if (nextValue == null) {
                return null;
            }
            int subjID = ByteArrayUtil.getInt(nextValue, 0);
            Resource subj = (Resource)((Object)this.valueStore.getValue(subjID));
            int predID = ByteArrayUtil.getInt(nextValue, 4);
            IRI pred = (IRI)((Object)this.valueStore.getValue(predID));
            int objID = ByteArrayUtil.getInt(nextValue, 8);
            NativeValue obj = this.valueStore.getValue(objID);
            Resource context = null;
            int contextID = ByteArrayUtil.getInt(nextValue, 12);
            if (contextID != 0) {
                context = (Resource)((Object)this.valueStore.getValue(contextID));
            }
            return this.valueStore.createStatement(subj, pred, (Value)obj, context);
        }
        catch (IOException e) {
            throw this.causeIOException(e);
        }
    }

    @Override
    protected void handleClose() throws SailException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.btreeIter.close();
            }
            catch (IOException e) {
                throw this.causeIOException(e);
            }
        }
    }

    protected SailException causeIOException(IOException e) {
        return new SailException(e);
    }
}

