/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BindSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChainRetriever;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetNode;

public class EffectiveTarget {
    private final ArrayDeque<EffectiveTargetObject> chain;
    private final EffectiveTargetObject optional;
    private final RdfsSubClassOfReasoner rdfsSubClassOfReasoner;

    public EffectiveTarget(ArrayDeque<Targetable> chain, Targetable optional, String targetVarPrefix, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        int index = 0;
        this.chain = new ArrayDeque();
        EffectiveTargetObject previous = null;
        for (Targetable targetable : chain) {
            EffectiveTargetObject effectiveTargetObject;
            previous = effectiveTargetObject = new EffectiveTargetObject(new StatementMatcher.Variable(targetVarPrefix + String.format("%010d", index++)), targetable, previous, rdfsSubClassOfReasoner);
            this.chain.addLast(effectiveTargetObject);
        }
        this.optional = optional != null ? new EffectiveTargetObject(new StatementMatcher.Variable(targetVarPrefix + String.format("%010d", index)), optional, previous, rdfsSubClassOfReasoner) : null;
        this.rdfsSubClassOfReasoner = rdfsSubClassOfReasoner;
    }

    public StatementMatcher.Variable getTargetVar() {
        return this.chain.getLast().var;
    }

    public PlanNode extend(PlanNode source, ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Extend direction, boolean includePropertyShapeValues) {
        String query = this.getQuery(includePropertyShapeValues);
        List<StatementMatcher.Variable> vars = this.getVars();
        if (includePropertyShapeValues) {
            vars = new ArrayList<StatementMatcher.Variable>(vars);
            vars.add(this.optional.var);
        }
        List varNames = vars.stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList());
        return new Unique(new BindSelect(connectionsGroup.getBaseConnection(), query, vars, source, bindingSet -> new ValidationTuple((BindingSet)bindingSet, varNames, scope, includePropertyShapeValues), 100, direction, includePropertyShapeValues, this.rdfsSubClassOfReasoner));
    }

    private List<StatementMatcher.Variable> getVars() {
        return this.chain.stream().map(t -> t.var).collect(Collectors.toList());
    }

    public boolean couldMatch(ConnectionsGroup connectionsGroup) {
        boolean hasTargetNode = Stream.concat(this.chain.stream(), this.getOptionalAsStream()).anyMatch(e -> e.target instanceof TargetNode);
        if (hasTargetNode) {
            return true;
        }
        return Stream.concat(this.chain.stream(), this.getOptionalAsStream()).flatMap(EffectiveTargetObject::getStatementMatcher).anyMatch(currentStatementPattern -> connectionsGroup.getAddedStatements().hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, new Resource[0]) || connectionsGroup.getRemovedStatements().hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, new Resource[0]));
    }

    private Stream<EffectiveTargetObject> getOptionalAsStream() {
        Stream<EffectiveTargetObject> optional = this.optional != null ? Stream.of(this.optional) : Stream.empty();
        return optional;
    }

    public PlanNode getAllTargets(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        List varNames = this.getVars().stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList());
        return new Select(connectionsGroup.getBaseConnection(), query, null, b -> new ValidationTuple((BindingSet)b, varNames, scope, false));
    }

    public PlanNode getPlanNode(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, boolean includeTargetsAffectedByRemoval) {
        assert (!this.chain.isEmpty());
        if (!(this.chain.size() != 1 || includeTargetsAffectedByRemoval && this.optional != null)) {
            EffectiveTargetObject last = this.chain.getLast();
            if (last.target instanceof Target) {
                return ((Target)last.target).getAdded(connectionsGroup, scope);
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        List<StatementMatcher> collect = this.chain.stream().flatMap(EffectiveTargetObject::getStatementMatcher).collect(Collectors.toList());
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        if (includeTargetsAffectedByRemoval && this.optional != null) {
            return new TargetChainRetriever(connectionsGroup, collect, this.optional.getStatementMatcher().collect(Collectors.toList()), query, this.getVars(), scope);
        }
        return new TargetChainRetriever(connectionsGroup, collect, null, query, this.getVars(), scope);
    }

    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, PlanNode parent) {
        EffectiveTargetObject last = this.chain.getLast();
        if (this.chain.size() == 1) {
            if (last.target instanceof Target) {
                return ((Target)last.target).getTargetFilter(connectionsGroup, parent);
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), parent, query, last.var, ValidationTuple::getActiveTarget).getTrueNode(UnBufferedPlanNode.class);
    }

    public String getQuery(boolean includeOptional) {
        ArrayDeque<EffectiveTargetObject> chain;
        if (includeOptional) {
            chain = new ArrayDeque<EffectiveTargetObject>(this.chain);
            chain.addLast(this.optional);
        } else {
            chain = this.chain;
        }
        return chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
    }

    static class EffectiveTargetObject {
        final StatementMatcher.Variable var;
        final Targetable target;
        final EffectiveTargetObject prev;
        final RdfsSubClassOfReasoner rdfsSubClassOfReasoner;

        public EffectiveTargetObject(StatementMatcher.Variable var, Targetable target, EffectiveTargetObject prev, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
            this.var = var;
            this.target = target;
            this.prev = prev;
            this.rdfsSubClassOfReasoner = rdfsSubClassOfReasoner;
        }

        public Stream<StatementMatcher> getStatementMatcher() {
            if (this.prev == null) {
                return this.target.getStatementMatcher(null, this.var, this.rdfsSubClassOfReasoner);
            }
            return this.target.getStatementMatcher(this.prev.var, this.var, this.rdfsSubClassOfReasoner);
        }

        public String getQueryFragment() {
            if (this.prev == null) {
                return this.target.getTargetQueryFragment(null, this.var, this.rdfsSubClassOfReasoner);
            }
            return this.target.getTargetQueryFragment(this.prev.var, this.var, this.rdfsSubClassOfReasoner);
        }
    }

    public static enum Extend {
        left,
        right;

    }
}

