/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iterator;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Iterators {
    public static <E> List<E> asList(Iterator<? extends E> iter) {
        ArrayList result = new ArrayList();
        Iterators.addAll(iter, result);
        return result;
    }

    public static <E, C extends Collection<E>> C addAll(Iterator<? extends E> iter, C collection) {
        while (iter.hasNext()) {
            collection.add(iter.next());
        }
        return collection;
    }

    public static String toString(Iterator<?> iter, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterators.toString(iter, separator, sb);
        return sb.toString();
    }

    public static void toString(Iterator<?> iter, String separator, StringBuilder sb) {
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
    }

    public static void close(Iterator<?> iter) throws IOException {
        if (iter instanceof Closeable) {
            ((Closeable)((Object)iter)).close();
        }
    }

    public static void closeSilently(Iterator<?> iter) {
        if (iter instanceof Closeable) {
            try {
                ((Closeable)((Object)iter)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

