/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.BoundFiltersNode;
import org.eclipse.rdf4j.federated.algebra.ConjunctiveFilterExpr;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterTuple;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.NodeFactory;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveGroup
extends AbstractQueryModelNode
implements StatementTupleExpr,
FilterTuple,
ExclusiveTupleExpr {
    private static final long serialVersionUID = 9215353191021766797L;
    private static final Logger log = LoggerFactory.getLogger(ExclusiveGroup.class);
    protected final List<ExclusiveTupleExpr> owned = new ArrayList<ExclusiveTupleExpr>();
    protected final StatementSource owner;
    protected final Set<String> freeVars = new HashSet<String>();
    protected final String id;
    protected final transient QueryInfo queryInfo;
    protected FilterValueExpr filterExpr = null;
    protected QueryBindingSet boundFilters = null;
    protected transient Endpoint ownedEndpoint = null;

    public ExclusiveGroup(Collection<? extends ExclusiveTupleExpr> ownedNodes, StatementSource owner, QueryInfo queryInfo) {
        this.owned.addAll(ownedNodes);
        this.owner = owner;
        this.init();
        this.id = NodeFactory.getNextId();
        this.queryInfo = queryInfo;
        this.ownedEndpoint = queryInfo.getFederationContext().getEndpointManager().getEndpoint(owner.getEndpointID());
        ownedNodes.forEach(node -> node.setParentNode(this));
    }

    protected void init() {
        for (ExclusiveTupleExpr o : this.owned) {
            this.freeVars.addAll(o.getFreeVars());
        }
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ExclusiveTupleExpr s : this.owned) {
            s.visit(visitor);
        }
        if (this.boundFilters != null) {
            BoundFiltersNode.visit(visitor, this.boundFilters);
        }
        if (this.filterExpr != null) {
            this.filterExpr.visit(visitor);
        }
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther(this);
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        HashSet<String> res = new HashSet<String>();
        this.owned.forEach(e -> res.addAll(e.getAssuredBindingNames()));
        return res;
    }

    @Override
    public Set<String> getBindingNames() {
        HashSet<String> res = new HashSet<String>();
        this.owned.forEach(e -> res.addAll(e.getBindingNames()));
        return res;
    }

    @Override
    public ExclusiveGroup clone() {
        throw new RuntimeException("Operation not supported on this node!");
    }

    @Override
    public StatementSource getOwner() {
        return this.owner;
    }

    public Endpoint getOwnedEndpoint() {
        return this.ownedEndpoint;
    }

    public List<ExclusiveTupleExpr> getExclusiveExpressions() {
        return this.owned;
    }

    @Override
    public int getFreeVarCount() {
        return this.freeVars.size();
    }

    @Override
    public List<String> getFreeVars() {
        return new ArrayList<String>(this.freeVars);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<StatementSource> getStatementSources() {
        return Collections.singletonList(this.owner);
    }

    @Override
    public boolean hasFreeVarsFor(BindingSet bindings) {
        for (String var : this.freeVars) {
            if (bindings.hasBinding(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        try {
            return this.queryInfo.getStrategy().evaluateExclusiveGroup(this, bindings);
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
    }

    @Override
    public void addFilterExpr(FilterExpr expr) {
        if (this.filterExpr == null) {
            this.filterExpr = expr;
        } else if (this.filterExpr instanceof ConjunctiveFilterExpr) {
            ((ConjunctiveFilterExpr)this.filterExpr).addExpression(expr);
        } else if (this.filterExpr instanceof FilterExpr) {
            this.filterExpr = new ConjunctiveFilterExpr((FilterExpr)this.filterExpr, expr);
        } else {
            throw new RuntimeException("Unexpected type: " + this.filterExpr.getClass().getCanonicalName());
        }
    }

    @Override
    public FilterValueExpr getFilterExpr() {
        return this.filterExpr;
    }

    @Override
    public BindingSet getBoundFilters() {
        return this.boundFilters;
    }

    @Override
    public boolean hasFilter() {
        return this.filterExpr != null;
    }

    @Override
    public void addBoundFilter(String varName, Value value) {
        if (!this.freeVars.contains(varName)) {
            log.debug("Invalid call to addBoundFilter: variable " + varName + " is not known as a free variable");
            return;
        }
        if (this.boundFilters == null) {
            this.boundFilters = new QueryBindingSet();
        }
        this.boundFilters.addBinding(varName, value);
        this.freeVars.remove(varName);
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }
}

