/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class StrLen
implements Function {
    @Override
    public String getURI() {
        return FN.STRING_LENGTH.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("STRLEN requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtility.isStringLiteral(literal)) {
                Integer length = literal.getLabel().length();
                return valueFactory.createLiteral(length.toString(), XSD.INTEGER);
            }
            throw new ValueExprEvaluationException("unexpected input value for strlen function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for strlen function: " + argValue);
    }
}

