/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemLiteral
extends SimpleLiteral
implements MemValue {
    private static final long serialVersionUID = 4288477328829845024L;
    private final transient Object creator;
    private final transient MemStatementList objectStatements = new MemStatementList();

    public MemLiteral(Object creator, String label) {
        super(label, XSD.STRING);
        this.creator = creator;
    }

    public MemLiteral(Object creator, String label, String lang) {
        super(label, lang);
        this.creator = creator;
    }

    public MemLiteral(Object creator, String label, IRI datatype) {
        super(label, datatype);
        this.creator = creator;
    }

    public MemLiteral(Object creator, String label, IRI datatype, CoreDatatype coreDatatype) {
        super(label, datatype, coreDatatype);
        this.creator = creator;
    }

    public MemLiteral(Object creator, String label, CoreDatatype datatype) {
        super(label, datatype);
        this.creator = creator;
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return !this.objectStatements.isEmpty();
    }

    @Override
    public MemStatementList getObjectStatementList() {
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        return this.objectStatements.size();
    }

    @Override
    public void addObjectStatement(MemStatement st) {
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        this.objectStatements.cleanSnapshots(currentSnapshot);
    }
}

