/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AllTargetsPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BindSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.RSXTargetShape;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChainRetriever;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class EffectiveTarget {
    public static final String TARGET_VAR_PREFIX = "target_";
    private final ArrayDeque<EffectiveTargetObject> chain;
    private final EffectiveTargetObject optional;

    public EffectiveTarget(ArrayDeque<Targetable> chain, Targetable optional, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        int index = 0;
        this.chain = new ArrayDeque();
        EffectiveTargetObject previous = null;
        for (Targetable targetable : chain) {
            EffectiveTargetObject effectiveTargetObject;
            previous = effectiveTargetObject = new EffectiveTargetObject(new StatementMatcher.Variable(TARGET_VAR_PREFIX + String.format("%010d", index++)), targetable, previous, rdfsSubClassOfReasoner, stableRandomVariableProvider);
            this.chain.addLast(effectiveTargetObject);
        }
        this.optional = optional != null ? new EffectiveTargetObject(new StatementMatcher.Variable(TARGET_VAR_PREFIX + String.format("%010d", index)), optional, previous, rdfsSubClassOfReasoner, stableRandomVariableProvider) : null;
    }

    public StatementMatcher.Variable getTargetVar() {
        return this.chain.getLast().var;
    }

    public PlanNode extend(PlanNode source, ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, Extend direction, boolean includePropertyShapeValues, Function<PlanNode, PlanNode> filter) {
        List<String> varNames;
        if (source instanceof AllTargetsPlanNode && !includePropertyShapeValues) {
            PlanNode allTargets = this.getAllTargets(connectionsGroup, dataGraph, scope);
            if (filter != null) {
                allTargets = filter.apply(allTargets);
            }
            return allTargets;
        }
        String query = this.getQuery(includePropertyShapeValues);
        List<StatementMatcher.Variable> vars = this.getVars();
        if (includePropertyShapeValues) {
            vars = new ArrayList<StatementMatcher.Variable>(vars);
            vars.add(this.optional.var);
        }
        if ((varNames = vars.stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList())).size() == 1) {
            PlanNode parent = new TupleMapper(source, new ActiveTargetTupleMapper(scope, includePropertyShapeValues, dataGraph));
            if (filter != null) {
                parent = filter.apply(parent);
            }
            return connectionsGroup.getCachedNodeFor(this.getTargetFilter(connectionsGroup, dataGraph, Unique.getInstance(parent, false)));
        }
        PlanNode parent = new BindSelect(connectionsGroup.getBaseConnection(), dataGraph, query, vars, source, varNames, scope, 1000, direction, includePropertyShapeValues);
        if (filter != null) {
            parent = connectionsGroup.getCachedNodeFor(parent);
            parent = filter.apply(parent);
            parent = Unique.getInstance(parent, true);
            return parent;
        }
        return connectionsGroup.getCachedNodeFor(Unique.getInstance(parent, true));
    }

    private List<StatementMatcher.Variable> getVars() {
        return this.chain.stream().map(t -> t.var).collect(Collectors.toList());
    }

    public boolean couldMatch(ConnectionsGroup connectionsGroup, Resource[] dataGraph) {
        boolean hasTargetNode = Stream.concat(this.chain.stream(), this.getOptionalAsStream()).anyMatch(e -> e.target instanceof TargetNode);
        if (hasTargetNode) {
            return true;
        }
        return Stream.concat(this.chain.stream(), this.getOptionalAsStream()).flatMap(EffectiveTargetObject::getStatementMatcher).anyMatch(currentStatementPattern -> connectionsGroup.getAddedStatements().hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, dataGraph) || connectionsGroup.getRemovedStatements().hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, dataGraph));
    }

    private Stream<EffectiveTargetObject> getOptionalAsStream() {
        Stream<EffectiveTargetObject> optional = this.optional != null ? Stream.of(this.optional) : Stream.empty();
        return optional;
    }

    public PlanNode getAllTargets(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return new AllTargetsPlanNode(connectionsGroup, dataGraph, this.chain, this.getVars(), scope);
    }

    public PlanNode getPlanNode(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, boolean includeTargetsAffectedByRemoval, Function<PlanNode, PlanNode> filter) {
        ArrayList<StatementMatcher> statementMatchersRemoval;
        assert (!this.chain.isEmpty());
        boolean bl = includeTargetsAffectedByRemoval = includeTargetsAffectedByRemoval && connectionsGroup.getStats().hasRemoved();
        if (!(this.chain.size() != 1 || includeTargetsAffectedByRemoval && this.optional != null)) {
            EffectiveTargetObject last = this.chain.getLast();
            if (last.target instanceof Target) {
                if (filter != null) {
                    return filter.apply(connectionsGroup.getCachedNodeFor(((Target)last.target).getAdded(connectionsGroup, dataGraph, scope)));
                }
                return connectionsGroup.getCachedNodeFor(((Target)last.target).getAdded(connectionsGroup, dataGraph, scope));
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        List<StatementMatcher> statementMatchers = this.chain.stream().flatMap(EffectiveTargetObject::getStatementMatcher).collect(Collectors.toList());
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        List<StatementMatcher> list = statementMatchersRemoval = this.optional != null ? (List)this.optional.getStatementMatcher().collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<StatementMatcher>();
        if (this.chain.getFirst().target instanceof RSXTargetShape) {
            statementMatchersRemoval.addAll(this.chain.getFirst().getStatementMatcher().collect(Collectors.toList()));
            includeTargetsAffectedByRemoval = true;
        }
        TargetChainRetriever targetChainRetriever = includeTargetsAffectedByRemoval ? new TargetChainRetriever(connectionsGroup, dataGraph, statementMatchers, statementMatchersRemoval, query, this.getVars(), scope) : new TargetChainRetriever(connectionsGroup, dataGraph, statementMatchers, null, query, this.getVars(), scope);
        if (filter != null) {
            return connectionsGroup.getCachedNodeFor(Unique.getInstance(filter.apply(targetChainRetriever), true));
        }
        return connectionsGroup.getCachedNodeFor(Unique.getInstance(targetChainRetriever, true));
    }

    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        EffectiveTargetObject last = this.chain.getLast();
        if (this.chain.size() == 1) {
            if (last.target instanceof Target) {
                return ((Target)last.target).getTargetFilter(connectionsGroup, dataGraph, parent);
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), dataGraph, parent, query, last.var, validationTuple -> validationTuple.getActiveTarget()).getTrueNode(UnBufferedPlanNode.class);
    }

    public String getQuery(boolean includeOptional) {
        ArrayDeque<EffectiveTargetObject> chain;
        if (includeOptional) {
            chain = new ArrayDeque<EffectiveTargetObject>(this.chain);
            chain.addLast(this.optional);
        } else {
            chain = this.chain;
        }
        return chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("") + "\n";
    }

    public List<StatementMatcher.Variable> getAllTargetVariables() {
        return this.chain.stream().map(c -> c.var).collect(Collectors.toCollection(ArrayList::new));
    }

    static class ActiveTargetTupleMapper
    implements Function<ValidationTuple, ValidationTuple> {
        private final ConstraintComponent.Scope scope;
        private final boolean includePropertyShapeValues;
        private final Resource[] contexts;

        public ActiveTargetTupleMapper(ConstraintComponent.Scope scope, boolean includePropertyShapeValues, Resource[] contexts) {
            this.scope = scope;
            this.includePropertyShapeValues = includePropertyShapeValues;
            this.contexts = contexts;
        }

        @Override
        public ValidationTuple apply(ValidationTuple validationTuple) {
            return new ValidationTuple(validationTuple.getActiveTarget(), this.scope, this.includePropertyShapeValues, this.contexts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActiveTargetTupleMapper that = (ActiveTargetTupleMapper)o;
            return this.includePropertyShapeValues == that.includePropertyShapeValues && this.scope == that.scope;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scope, this.includePropertyShapeValues});
        }
    }

    public static class EffectiveTargetObject {
        private final StatementMatcher.Variable var;
        private final Targetable target;
        private final EffectiveTargetObject prev;
        private final RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
        private final StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider;

        public EffectiveTargetObject(StatementMatcher.Variable var, Targetable target, EffectiveTargetObject prev, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
            this.var = var;
            this.target = target;
            this.prev = prev;
            this.rdfsSubClassOfReasoner = rdfsSubClassOfReasoner;
            this.stableRandomVariableProvider = stableRandomVariableProvider;
        }

        public Stream<StatementMatcher> getStatementMatcher() {
            if (this.prev == null) {
                return this.target.getStatementMatcher(null, this.var, this.rdfsSubClassOfReasoner);
            }
            return this.target.getStatementMatcher(this.prev.var, this.var, this.rdfsSubClassOfReasoner);
        }

        public String getQueryFragment() {
            if (this.prev == null) {
                return this.target.getTargetQueryFragment(null, this.var, this.rdfsSubClassOfReasoner, this.stableRandomVariableProvider);
            }
            return this.target.getTargetQueryFragment(this.prev.var, this.var, this.rdfsSubClassOfReasoner, this.stableRandomVariableProvider);
        }
    }

    public static enum Extend {
        left,
        right;

    }
}

