/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;

public final class SearchFields {
    public static final String ID_FIELD_NAME = "id";
    public static final String URI_FIELD_NAME = "uri";
    public static final String TEXT_FIELD_NAME = "text";
    public static final String CONTEXT_FIELD_NAME = "context";
    public static final String CONTEXT_NULL = "null";
    public static final String BNODE_ID_PREFIX = "!";
    public static final String HIGHLIGHTER_PRE_TAG = "<B>";
    public static final String HIGHLIGHTER_POST_TAG = "</B>";
    public static final Pattern HIGHLIGHTER_PATTERN = Pattern.compile("(<B>.+?</B>)");
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();

    private SearchFields() {
    }

    public static String getResourceID(Resource resource) {
        if (resource instanceof IRI) {
            return resource.toString();
        }
        if (resource instanceof BNode) {
            return BNODE_ID_PREFIX + ((BNode)resource).getID();
        }
        throw new IllegalArgumentException("Unknown Resource type: " + resource);
    }

    public static String getContextID(Resource resource) {
        if (resource == null) {
            return CONTEXT_NULL;
        }
        return SearchFields.getResourceID(resource);
    }

    public static Resource createResource(String idString) {
        if (idString.startsWith(BNODE_ID_PREFIX)) {
            return valueFactory.createBNode(idString.substring(BNODE_ID_PREFIX.length()));
        }
        return valueFactory.createIRI(idString);
    }

    public static Resource createContext(String idString) {
        if (CONTEXT_NULL.equals(idString)) {
            return null;
        }
        return SearchFields.createResource(idString);
    }

    public static String getLiteralPropertyValueAsString(Statement statement) {
        Value object = statement.getObject();
        if (object instanceof Literal) {
            return ((Literal)object).getLabel();
        }
        return null;
    }

    public static String getPropertyField(IRI property) {
        return property.toString();
    }

    public static boolean isPropertyField(String fieldName) {
        return !ID_FIELD_NAME.equals(fieldName) && !URI_FIELD_NAME.equals(fieldName) && !TEXT_FIELD_NAME.equals(fieldName) && !CONTEXT_FIELD_NAME.equals(fieldName) && fieldName.charAt(0) != '_';
    }

    public static String formIdString(String resourceId, String contextId) {
        StringBuilder idBuilder = new StringBuilder(resourceId);
        idBuilder.append("|");
        idBuilder.append(contextId);
        return idBuilder.toString();
    }

    public static Literal scoreToLiteral(float score) {
        return valueFactory.createLiteral(score);
    }

    public static Literal wktToLiteral(String wkt) {
        return valueFactory.createLiteral(wkt, GEO.WKT_LITERAL);
    }

    public static Literal distanceToLiteral(double d) {
        return valueFactory.createLiteral(d);
    }

    public static String getSnippet(String highlightedValue) {
        if (highlightedValue.length() > 100) {
            StringBuilder buf = new StringBuilder();
            String separator = "";
            Matcher matcher = HIGHLIGHTER_PATTERN.matcher(highlightedValue);
            for (int i = 0; i < 2 && matcher.find(); ++i) {
                buf.append(separator);
                buf.append(matcher.group());
                separator = "...";
            }
            highlightedValue = buf.toString();
        }
        return highlightedValue;
    }
}

