/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class GroupByFilter
implements PlanNode {
    private final Function<Collection<ValidationTuple>, Boolean> filter;
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public GroupByFilter(PlanNode parent, Function<Collection<ValidationTuple>, Boolean> filter) {
        this.parent = PlanNodeHelper.handleSorting(this, parent);
        this.filter = filter;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            ValidationTuple next;
            ValidationTuple tempNext;
            final List<ValidationTuple> group;
            {
                this.parentIterator = GroupByFilter.this.parent.iterator();
                this.group = new ArrayList<ValidationTuple>();
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                while (this.next == null && (this.tempNext != null || this.parentIterator.hasNext())) {
                    if (this.tempNext == null) {
                        this.tempNext = (ValidationTuple)this.parentIterator.next();
                    }
                    this.next = this.tempNext;
                    this.group.clear();
                    while (this.tempNext != null && this.tempNext.sameTargetAs(this.next)) {
                        if (this.tempNext.hasValue()) {
                            this.group.add(this.tempNext);
                        }
                        this.tempNext = null;
                        if (!this.parentIterator.hasNext()) continue;
                        this.tempNext = (ValidationTuple)this.parentIterator.next();
                    }
                    if (GroupByFilter.this.filter.apply(this.group).booleanValue()) continue;
                    this.next = null;
                }
            }

            @Override
            public void localClose() throws SailException {
                this.parentIterator.close();
                this.group.clear();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "GroupByCountFilter";
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupByFilter that = (GroupByFilter)o;
        return this.filter.equals(that.filter) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.parent);
    }
}

