/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import com.google.common.base.Objects;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemTriple
extends MemResource
implements Triple {
    private static final long serialVersionUID = -9085188980084028689L;
    private final transient Object creator;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final transient MemStatementList objectStatements = new MemStatementList();

    public MemTriple(Object creator, MemResource subject, MemIRI predicate, MemValue object) {
        this.creator = creator;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public String stringValue() {
        return "<<" + this.getSubject() + " " + this.getPredicate() + " " + this.getObject() + ">>";
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return false;
    }

    @Override
    public MemStatementList getObjectStatementList() {
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        return this.getObjectStatementList().size();
    }

    @Override
    public void addObjectStatement(MemStatement st) throws InterruptedException {
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) throws InterruptedException {
        this.objectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) throws InterruptedException {
        this.objectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getContextStatementList() {
        return EMPTY_LIST;
    }

    @Override
    public int getContextStatementCount() {
        return 0;
    }

    @Override
    public void addContextStatement(MemStatement st) {
        throw new UnsupportedOperationException("RDF-star triples can not be used as context identifier");
    }

    @Override
    public void removeContextStatement(MemStatement st) {
    }

    @Override
    public void cleanSnapshotsFromContextStatements(int currentSnapshot) {
    }

    public MemResource getSubject() {
        return this.subject;
    }

    public MemIRI getPredicate() {
        return this.predicate;
    }

    public MemValue getObject() {
        return this.object;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subject, this.predicate, this.object});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Triple) {
            Triple that = (Triple)other;
            return this.subject.equals(that.getSubject()) && this.predicate.equals(that.getPredicate()) && this.object.equals(that.getObject());
        }
        return false;
    }

    @Override
    public boolean hasPredicateStatements() {
        return false;
    }

    @Override
    public boolean hasObjectStatements() {
        return !this.objectStatements.isEmpty();
    }

    @Override
    public boolean hasContextStatements() {
        return false;
    }

    public boolean matchesSPO(MemResource subject, MemIRI predicate, MemValue object) {
        return !(object != null && object != this.object || subject != null && subject != this.subject || predicate != null && predicate != this.predicate);
    }
}

