/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;

public class CloseableIteratorIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private Iterator<? extends E> iter;

    public CloseableIteratorIteration() {
    }

    public CloseableIteratorIteration(Iterator<? extends E> iter) {
        this.setIterator(iter);
    }

    protected void setIterator(Iterator<? extends E> iter) {
        this.iter = Objects.requireNonNull(iter, "Iterator was null");
    }

    protected boolean hasIterator() {
        return this.iter != null;
    }

    @Override
    public boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        boolean result = this.iter.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        return this.iter.next();
    }

    @Override
    public void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException("Iteration has been closed");
        }
        this.iter.remove();
    }
}

