/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.GraphPatternGroupable;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.VariableScopeChange;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class TupleExprs {
    public static boolean containsSubquery(TupleExpr t) {
        TupleExpr n = t;
        ArrayDeque<TupleExpr> queue = null;
        do {
            if (n instanceof Projection && ((Projection)n).isSubquery()) {
                return true;
            }
            if (n instanceof Join) {
                return false;
            }
            List<TupleExpr> children = TupleExprs.getChildren(n);
            if (children.isEmpty()) continue;
            if (queue == null) {
                queue = new ArrayDeque<TupleExpr>();
            }
            queue.addAll(children);
        } while ((n = queue != null ? (TupleExpr)queue.poll() : null) != null);
        return false;
    }

    public static boolean isVariableScopeChange(TupleExpr expr) {
        if (expr instanceof VariableScopeChange) {
            return ((VariableScopeChange)((Object)expr)).isVariableScopeChange();
        }
        return false;
    }

    @Deprecated
    public static boolean isGraphPatternGroup(TupleExpr expr) {
        if (expr instanceof GraphPatternGroupable) {
            return ((GraphPatternGroupable)((Object)expr)).isGraphPatternGroup();
        }
        return false;
    }

    @Deprecated
    public static boolean containsProjection(TupleExpr t) {
        ArrayDeque<TupleExpr> queue = new ArrayDeque<TupleExpr>();
        queue.add(t);
        while (!queue.isEmpty()) {
            TupleExpr n = (TupleExpr)queue.removeFirst();
            if (n instanceof Projection) {
                return true;
            }
            if (n instanceof Join) {
                return false;
            }
            queue.addAll(TupleExprs.getChildren(n));
        }
        return false;
    }

    public static List<TupleExpr> getChildren(TupleExpr t) {
        TupleExprChildrenVisitor visitor = new TupleExprChildrenVisitor();
        t.visitChildren(visitor);
        return visitor.getChildren();
    }

    public static Var createConstVar(Value value) {
        String varName = TupleExprs.getConstVarName(value);
        return new Var(varName, value, true, true);
    }

    public static String getConstVarName(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        Object uniqueStringForValue = Integer.toHexString(value.stringValue().hashCode());
        if (value instanceof Literal) {
            uniqueStringForValue = (String)uniqueStringForValue + "_lit";
            Literal lit = (Literal)value;
            if (lit.getDatatype() != null) {
                uniqueStringForValue = (String)uniqueStringForValue + "_" + Integer.toHexString(lit.getDatatype().hashCode());
            }
            if (lit.getLanguage().isPresent()) {
                uniqueStringForValue = (String)uniqueStringForValue + "_" + Integer.toHexString(lit.getLanguage().hashCode());
            }
        } else {
            uniqueStringForValue = value instanceof BNode ? (String)uniqueStringForValue + "_node" : (String)uniqueStringForValue + "_uri";
        }
        return "_const_" + (String)uniqueStringForValue;
    }

    public static boolean isFilterExistsFunction(TupleExpr expr) {
        if (expr instanceof Filter) {
            Filter filter = (Filter)expr;
            if (filter.getCondition() instanceof Exists) {
                return true;
            }
            if (filter.getCondition() instanceof Not) {
                Not n = (Not)filter.getCondition();
                return n.getArg() instanceof Exists;
            }
        }
        return false;
    }

    private static class TupleExprChildrenVisitor<X extends Exception>
    extends AbstractQueryModelVisitor<X> {
        private List<TupleExpr> children;

        private TupleExprChildrenVisitor() {
        }

        @Override
        public void meetNode(QueryModelNode node) {
            if (node instanceof TupleExpr) {
                if (this.children == null) {
                    this.children = Collections.singletonList((TupleExpr)node);
                } else if (this.children.size() == 1) {
                    this.children = new ArrayList<TupleExpr>(this.children);
                    this.children.add((TupleExpr)node);
                } else {
                    this.children.add((TupleExpr)node);
                }
            }
        }

        public List<TupleExpr> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children;
        }
    }
}

