/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public class StatementPatternQueryEvaluationStep
implements QueryEvaluationStep {
    public static final Resource[] DEFAULT_CONTEXT = new Resource[]{null};
    public static final Resource[] ALL_CONTEXT = new Resource[0];
    private final StatementPattern statementPattern;
    private final TripleSource tripleSource;
    private final boolean emptyGraph;
    private final Function<Value, Resource[]> contextSup;
    private final BiConsumer<MutableBindingSet, Statement> converter;
    private final QueryEvaluationContext context;
    private final Predicate<BindingSet> unboundTest;
    private final Function<BindingSet, Value> getContextVar;
    private final Function<BindingSet, Value> getSubjectVar;
    private final Function<BindingSet, Value> getPredicateVar;
    private final Function<BindingSet, Value> getObjectVar;

    public StatementPatternQueryEvaluationStep(StatementPattern statementPattern, QueryEvaluationContext context, TripleSource tripleSource) {
        this.statementPattern = statementPattern;
        this.context = context;
        this.tripleSource = tripleSource;
        Set graphs = null;
        Dataset dataset = context.getDataset();
        this.emptyGraph = dataset != null ? (statementPattern.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS ? (graphs = dataset.getDefaultGraphs()).isEmpty() && !dataset.getNamedGraphs().isEmpty() : (graphs = dataset.getNamedGraphs()).isEmpty() && !dataset.getDefaultGraphs().isEmpty()) : false;
        this.contextSup = StatementPatternQueryEvaluationStep.extractContextsFromDatasets(statementPattern.getContextVar(), this.emptyGraph, graphs);
        Var subjVar = statementPattern.getSubjectVar();
        Var predVar = statementPattern.getPredicateVar();
        Var objVar = statementPattern.getObjectVar();
        Var conVar = statementPattern.getContextVar();
        this.converter = StatementPatternQueryEvaluationStep.makeConverter(context, subjVar, predVar, objVar, conVar);
        this.unboundTest = StatementPatternQueryEvaluationStep.getUnboundTest(context, subjVar, predVar, objVar, conVar);
        this.getContextVar = StatementPatternQueryEvaluationStep.makeGetVarValue(conVar, context);
        this.getSubjectVar = StatementPatternQueryEvaluationStep.makeGetVarValue(subjVar, context);
        this.getPredicateVar = StatementPatternQueryEvaluationStep.makeGetVarValue(predVar, context);
        this.getObjectVar = StatementPatternQueryEvaluationStep.makeGetVarValue(objVar, context);
    }

    private static Predicate<BindingSet> getUnboundTest(QueryEvaluationContext context, Var subjVar, Var predVar, Var objVar, Var conVar) {
        Predicate<BindingSet> isSubjBound = StatementPatternQueryEvaluationStep.unbound(subjVar, context);
        Predicate<BindingSet> isPredBound = StatementPatternQueryEvaluationStep.unbound(predVar, context);
        Predicate<BindingSet> isObjBound = StatementPatternQueryEvaluationStep.unbound(objVar, context);
        Predicate<BindingSet> isConBound = StatementPatternQueryEvaluationStep.unbound(conVar, context);
        return bs -> {
            if (!bs.isEmpty()) {
                return isSubjBound != null && isSubjBound.test((BindingSet)bs) || isPredBound != null && isPredBound.test((BindingSet)bs) || isObjBound != null && isObjBound.test((BindingSet)bs) || isConBound != null && isConBound.test((BindingSet)bs);
            }
            return false;
        };
    }

    private static Function<BindingSet, Value> makeGetVarValue(Var var, QueryEvaluationContext context) {
        if (var == null) {
            return b -> null;
        }
        if (var.hasValue()) {
            Value value = var.getValue();
            return b -> value;
        }
        return context.getValue(var.getName());
    }

    private static Predicate<BindingSet> unbound(Var var, QueryEvaluationContext context) {
        if (var == null || var.isConstant()) {
            return null;
        }
        Predicate<BindingSet> hasBinding = context.hasBinding(var.getName());
        Function<BindingSet, Value> getValue = context.getValue(var.getName());
        Predicate<BindingSet> getBindingIsNull = binding -> getValue.apply((BindingSet)binding) == null;
        return hasBinding.and(getBindingIsNull);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
        if (this.emptyGraph) {
            return EMPTY_ITERATION;
        }
        if (bindings.isEmpty()) {
            ConvertStatementToBindingSetIterator iteration = this.getIteration();
            if (iteration == null) {
                return EMPTY_ITERATION;
            }
            return iteration;
        }
        if (this.unboundTest.test(bindings)) {
            return EMPTY_ITERATION;
        }
        JoinStatementWithBindingSetIterator iteration = this.getIteration(bindings);
        if (iteration == null) {
            return EMPTY_ITERATION;
        }
        return iteration;
    }

    private JoinStatementWithBindingSetIterator getIteration(BindingSet bindings) {
        Value contextValue = this.getContextVar.apply(bindings);
        Resource[] contexts = this.contextSup.apply(contextValue);
        if (contexts == null) {
            return null;
        }
        Value subject = this.getSubjectVar.apply(bindings);
        if (subject != null && !subject.isResource()) {
            return null;
        }
        Value predicate = this.getPredicateVar.apply(bindings);
        if (predicate != null && !predicate.isIRI()) {
            return null;
        }
        Value object = this.getObjectVar.apply(bindings);
        CloseableIteration<? extends Statement, QueryEvaluationException> iteration = null;
        try {
            iteration = this.tripleSource.getStatements((Resource)subject, (IRI)predicate, object, contexts);
            if (iteration instanceof EmptyIteration) {
                return null;
            }
            iteration = this.handleFilter(contexts, (Resource)subject, (IRI)predicate, object, iteration);
            return new JoinStatementWithBindingSetIterator(iteration, this.converter, bindings, this.context);
        }
        catch (Throwable t) {
            if (iteration != null) {
                iteration.close();
            }
            throw new QueryEvaluationException(t);
        }
    }

    private ConvertStatementToBindingSetIterator getIteration() {
        Var contextVar = this.statementPattern.getContextVar();
        Resource[] contexts = this.contextSup.apply(contextVar != null ? contextVar.getValue() : null);
        if (contexts == null) {
            return null;
        }
        Value subject = this.statementPattern.getSubjectVar().getValue();
        Value predicate = this.statementPattern.getPredicateVar().getValue();
        Value object = this.statementPattern.getObjectVar().getValue();
        if (subject != null && !subject.isResource() || predicate != null && !predicate.isIRI()) {
            return null;
        }
        CloseableIteration<? extends Statement, QueryEvaluationException> iteration = null;
        try {
            iteration = this.tripleSource.getStatements((Resource)subject, (IRI)predicate, object, contexts);
            iteration = this.handleFilter(contexts, (Resource)subject, (IRI)predicate, object, iteration);
            return new ConvertStatementToBindingSetIterator(iteration, this.converter, this.context);
        }
        catch (Throwable t) {
            if (iteration != null) {
                iteration.close();
            }
            throw new QueryEvaluationException(t);
        }
    }

    private CloseableIteration<? extends Statement, QueryEvaluationException> handleFilter(Resource[] contexts, Resource subject, IRI predicate, Value object, CloseableIteration<? extends Statement, QueryEvaluationException> iteration) {
        final Predicate<Statement> filter = StatementPatternQueryEvaluationStep.filterContextOrEqualVariables(this.statementPattern, (Value)subject, (Value)predicate, object, contexts);
        if (filter != null) {
            return new FilterIteration<Statement, QueryEvaluationException>(iteration){

                protected boolean accept(Statement object) throws QueryEvaluationException {
                    return filter.test(object);
                }
            };
        }
        return iteration;
    }

    protected static Predicate<Statement> filterContextOrEqualVariables(StatementPattern statementPattern, Value subjValue, Value predValue, Value objValue, Resource[] contexts) {
        Predicate<Statement> filter = null;
        if (contexts.length == 0 && statementPattern.getScope() == StatementPattern.Scope.NAMED_CONTEXTS) {
            filter = st -> st.getContext() != null;
        }
        return StatementPatternQueryEvaluationStep.filterSameVariable(statementPattern, subjValue, predValue, objValue, filter);
    }

    private static Predicate<Statement> filterSameVariable(StatementPattern statementPattern, Value subjValue, Value predValue, Value objValue, Predicate<Statement> filter) {
        boolean objEqConVar;
        Var subjVar = statementPattern.getSubjectVar();
        Var predVar = statementPattern.getPredicateVar();
        Var objVar = statementPattern.getObjectVar();
        Var conVar = statementPattern.getContextVar();
        if (subjVar != null && subjValue == null) {
            boolean subEqPredVar = subjVar.equals((Object)predVar);
            boolean subEqObjVar = subjVar.equals((Object)objVar);
            boolean subEqConVar = subjVar.equals((Object)conVar);
            if (subEqPredVar || subEqObjVar || subEqConVar) {
                filter = StatementPatternQueryEvaluationStep.andThen(filter, StatementPatternQueryEvaluationStep.subjectVariableHasEquals(subEqPredVar, subEqObjVar, subEqConVar));
            }
        }
        if (predVar != null && predValue == null) {
            boolean predEqObjVar = predVar.equals((Object)objVar);
            boolean predEqConVar = predVar.equals((Object)conVar);
            if (predEqObjVar || predEqConVar) {
                filter = StatementPatternQueryEvaluationStep.andThen(filter, StatementPatternQueryEvaluationStep.predicateVariableHasEquals(predEqObjVar, predEqConVar));
            }
        }
        if (objVar != null && objValue == null && (objEqConVar = objVar.equals((Object)conVar))) {
            filter = StatementPatternQueryEvaluationStep.andThen(filter, st -> {
                Value obj = st.getObject();
                Resource context = st.getContext();
                return obj.equals(context);
            });
        }
        return filter;
    }

    private static Predicate<Statement> predicateVariableHasEquals(boolean predEqObjVar, boolean predEqConVar) {
        Predicate<Statement> eq = null;
        if (predEqObjVar) {
            eq = st -> st.getPredicate().equals((Object)st.getObject());
        }
        if (predEqConVar) {
            eq = StatementPatternQueryEvaluationStep.andThen(eq, st -> st.getPredicate().equals((Object)st.getContext()));
        }
        return eq;
    }

    private static Predicate<Statement> subjectVariableHasEquals(boolean subEqPredVar, boolean subEqObjVar, boolean subEqConVar) {
        Predicate<Statement> eq = null;
        if (subEqPredVar) {
            eq = st -> st.getSubject().equals(st.getPredicate());
        }
        if (subEqObjVar) {
            eq = StatementPatternQueryEvaluationStep.andThen(eq, st -> st.getSubject().equals(st.getObject()));
        }
        if (subEqConVar) {
            eq = StatementPatternQueryEvaluationStep.andThen(eq, st -> st.getSubject().equals(st.getContext()));
        }
        return eq;
    }

    protected static Function<Value, Resource[]> extractContextsFromDatasets(Var contextVar, boolean emptyGraph, Set<IRI> graphs) {
        if (emptyGraph) {
            return cv -> null;
        }
        if (graphs == null || graphs.isEmpty()) {
            return StatementPatternQueryEvaluationStep::contextsGivenContextVal;
        }
        Resource[] filled = StatementPatternQueryEvaluationStep.fillContextsFromDatasSetGraphs(graphs);
        if (contextVar == null) {
            return contextValue -> filled;
        }
        return contextValue -> {
            if (contextValue != null) {
                if (contextValue.isIRI() && graphs.contains((IRI)contextValue)) {
                    return new Resource[]{(Resource)contextValue};
                }
                return null;
            }
            return filled;
        };
    }

    private static Resource[] contextsGivenContextVal(Value contextValue) {
        if (contextValue != null) {
            if (RDF4J.NIL.equals((Object)contextValue) || SESAME.NIL.equals((Object)contextValue)) {
                return DEFAULT_CONTEXT;
            }
            return new Resource[]{(Resource)contextValue};
        }
        return ALL_CONTEXT;
    }

    private static Resource[] fillContextsFromDatasSetGraphs(Set<IRI> graphs) {
        Resource[] contexts = new Resource[graphs.size()];
        int i = 0;
        for (IRI graph : graphs) {
            IRI context = null;
            if (!RDF4J.NIL.equals((Object)graph) && !SESAME.NIL.equals((Object)graph)) {
                context = graph;
            }
            contexts[i++] = context;
        }
        return contexts;
    }

    private static BiConsumer<MutableBindingSet, Statement> makeConverter(QueryEvaluationContext context, Var subjVar, Var predVar, Var objVar, Var conVar) {
        return Stream.of(subjVar, predVar, objVar, conVar).filter(Objects::nonNull).filter(var -> !var.isConstant()).distinct().map(var -> {
            BiConsumer<Value, MutableBindingSet> setVar = context.addBinding(var.getName());
            Predicate<BindingSet> varIsNotSet = Predicate.not(context.hasBinding(var.getName()));
            if (var == subjVar) {
                return (result, st) -> {
                    if (result.isEmpty() || varIsNotSet.test((BindingSet)result)) {
                        setVar.accept((Value)st.getSubject(), (MutableBindingSet)result);
                    }
                };
            }
            if (var == predVar) {
                return (result, st) -> {
                    if (result.isEmpty() || varIsNotSet.test((BindingSet)result)) {
                        setVar.accept((Value)st.getPredicate(), (MutableBindingSet)result);
                    }
                };
            }
            if (var == objVar) {
                return (result, st) -> {
                    if (result.isEmpty() || varIsNotSet.test((BindingSet)result)) {
                        setVar.accept(st.getObject(), (MutableBindingSet)result);
                    }
                };
            }
            return (result, st) -> {
                if (result.isEmpty() || varIsNotSet.test((BindingSet)result)) {
                    setVar.accept((Value)st.getContext(), (MutableBindingSet)result);
                }
            };
        }).reduce(BiConsumer::andThen).orElse((a, b) -> {});
    }

    private static Predicate<Statement> andThen(Predicate<Statement> pred, Predicate<Statement> and) {
        if (pred == null) {
            return and;
        }
        return pred.and(and);
    }

    private static final class JoinStatementWithBindingSetIterator
    implements CloseableIteration<BindingSet, QueryEvaluationException> {
        private final BiConsumer<MutableBindingSet, Statement> action;
        private final QueryEvaluationContext context;
        private final BindingSet bindings;
        private final CloseableIteration<? extends Statement, ? extends QueryEvaluationException> iteration;
        private boolean closed = false;

        private JoinStatementWithBindingSetIterator(CloseableIteration<? extends Statement, ? extends QueryEvaluationException> iteration, BiConsumer<MutableBindingSet, Statement> action, BindingSet bindings, QueryEvaluationContext context) {
            this.iteration = Objects.requireNonNull(iteration, "The iterator was null");
            assert (!bindings.isEmpty());
            this.action = action;
            this.context = context;
            this.bindings = bindings;
        }

        private BindingSet convert(Statement st) {
            MutableBindingSet made = this.context.createBindingSet(this.bindings);
            this.action.accept(made, st);
            return made;
        }

        public boolean hasNext() throws QueryEvaluationException {
            return this.iteration.hasNext();
        }

        public BindingSet next() throws QueryEvaluationException {
            return this.convert((Statement)this.iteration.next());
        }

        public void remove() throws QueryEvaluationException {
            this.iteration.remove();
        }

        public void close() throws QueryEvaluationException {
            if (!this.closed) {
                this.closed = true;
                this.iteration.close();
            }
        }
    }

    private static final class ConvertStatementToBindingSetIterator
    implements CloseableIteration<BindingSet, QueryEvaluationException> {
        private final BiConsumer<MutableBindingSet, Statement> action;
        private final QueryEvaluationContext context;
        private final CloseableIteration<? extends Statement, ? extends QueryEvaluationException> iteration;
        private boolean closed = false;

        private ConvertStatementToBindingSetIterator(CloseableIteration<? extends Statement, ? extends QueryEvaluationException> iteration, BiConsumer<MutableBindingSet, Statement> action, QueryEvaluationContext context) {
            this.iteration = Objects.requireNonNull(iteration, "The iterator was null");
            this.action = action;
            this.context = context;
        }

        private BindingSet convert(Statement st) {
            MutableBindingSet made = this.context.createBindingSet();
            this.action.accept(made, st);
            return made;
        }

        public boolean hasNext() throws QueryEvaluationException {
            return this.iteration.hasNext();
        }

        public BindingSet next() throws QueryEvaluationException {
            return this.convert((Statement)this.iteration.next());
        }

        public void remove() throws QueryEvaluationException {
            this.iteration.remove();
        }

        public void close() throws QueryEvaluationException {
            if (!this.closed) {
                this.closed = true;
                this.iteration.close();
            }
        }
    }
}

