/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;

public class QueryJoinOptimizer
implements QueryOptimizer {
    protected final EvaluationStatistics statistics;
    private final boolean trackResultSize;

    public QueryJoinOptimizer(EvaluationStatistics statistics) {
        this(statistics, false);
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics, boolean trackResultSize) {
        this.statistics = statistics;
        this.trackResultSize = trackResultSize;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new JoinVisitor(this.statistics, this.trackResultSize));
    }

    private static class JoinVisitor
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private final EvaluationStatistics statistics;
        Set<String> boundVars = new HashSet<String>();

        protected JoinVisitor(EvaluationStatistics statistics, boolean trackResultSize) {
            super(trackResultSize);
            this.statistics = statistics;
        }

        public void meet(LeftJoin leftJoin) {
            leftJoin.getLeftArg().visit((QueryModelVisitor)this);
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                this.boundVars.addAll(leftJoin.getLeftArg().getBindingNames());
                leftJoin.getRightArg().visit((QueryModelVisitor)this);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        public void meet(StatementPattern node) throws RuntimeException {
            node.setResultSizeEstimate(Math.max(this.statistics.getCardinality((TupleExpr)node), node.getResultSizeEstimate()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void optimizePriorityJoin(Set<String> origBoundVars, TupleExpr join) {
            Set<String> saveBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(origBoundVars);
                join.visit((QueryModelVisitor)this);
            }
            finally {
                this.boundVars = saveBoundVars;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void meet(Join node) {
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                ArrayList<TupleExpr> joinArgs = this.getJoinArgs((TupleExpr)node, new ArrayList());
                ArrayList<TupleExpr> orderedJoinArgs = new ArrayList<TupleExpr>(joinArgs.size());
                ArrayList<Object> priorityArgs = new ArrayList<Object>(joinArgs.size());
                List<Extension> orderedExtensions = this.getExtensions(joinArgs);
                joinArgs.removeAll(orderedExtensions);
                priorityArgs.addAll(orderedExtensions);
                List<TupleExpr> orderedSubselects = this.reorderSubselects(this.getSubSelects(joinArgs));
                joinArgs.removeAll(orderedSubselects);
                priorityArgs.addAll(orderedSubselects);
                if (joinArgs.size() > 0) {
                    HashMap<TupleExpr, Double> cardinalityMap = new HashMap<TupleExpr, Double>();
                    HashMap<TupleExpr, List<Var>> varsMap = new HashMap<TupleExpr, List<Var>>();
                    for (TupleExpr tupleExpr : joinArgs) {
                        double cardinality = this.statistics.getCardinality(tupleExpr);
                        tupleExpr.setResultSizeEstimate(Math.max(cardinality, tupleExpr.getResultSizeEstimate()));
                        cardinalityMap.put(tupleExpr, cardinality);
                        if (tupleExpr instanceof ZeroLengthPath) {
                            varsMap.put(tupleExpr, ((ZeroLengthPath)tupleExpr).getVarList());
                            continue;
                        }
                        varsMap.put(tupleExpr, this.getStatementPatternVars(tupleExpr));
                    }
                    HashMap<Var, Integer> varFreqMap = new HashMap<Var, Integer>();
                    for (List varList : varsMap.values()) {
                        this.fillVarFreqMap(varList, varFreqMap);
                    }
                    while (!joinArgs.isEmpty()) {
                        TupleExpr tupleExpr = this.selectNextTupleExpr(joinArgs, cardinalityMap, varsMap, varFreqMap);
                        joinArgs.remove(tupleExpr);
                        orderedJoinArgs.add(tupleExpr);
                        tupleExpr.visit((QueryModelVisitor)this);
                        this.boundVars.addAll(tupleExpr.getBindingNames());
                    }
                }
                TupleExpr priorityJoins = null;
                if (priorityArgs.size() > 0) {
                    priorityJoins = (TupleExpr)priorityArgs.get(0);
                    for (int i = 1; i < priorityArgs.size(); ++i) {
                        priorityJoins = new Join(priorityJoins, (TupleExpr)priorityArgs.get(i));
                    }
                }
                if (orderedJoinArgs.size() > 0) {
                    int i = orderedJoinArgs.size() - 1;
                    TupleExpr replacement = (TupleExpr)orderedJoinArgs.get(i);
                    --i;
                    while (i >= 0) {
                        replacement = new Join((TupleExpr)orderedJoinArgs.get(i), replacement);
                        --i;
                    }
                    if (priorityJoins != null) {
                        replacement = new Join(priorityJoins, replacement);
                    }
                    node.replaceWith((QueryModelNode)replacement);
                    if (priorityJoins != null) {
                        this.optimizePriorityJoin(origBoundVars, priorityJoins);
                    }
                } else {
                    node.replaceWith((QueryModelNode)priorityJoins);
                }
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        protected <L extends List<TupleExpr>> L getJoinArgs(TupleExpr tupleExpr, L joinArgs) {
            if (tupleExpr instanceof Join) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            } else {
                joinArgs.add((TupleExpr)tupleExpr);
            }
            return joinArgs;
        }

        protected List<Var> getStatementPatternVars(TupleExpr tupleExpr) {
            if (tupleExpr instanceof StatementPattern) {
                return ((StatementPattern)tupleExpr).getVarList();
            }
            return new StatementPatternVarCollector(tupleExpr).getVars();
        }

        protected <M extends Map<Var, Integer>> void fillVarFreqMap(List<Var> varList, M varFreqMap) {
            for (Var var : varList) {
                varFreqMap.compute((Var)var, (k, v) -> {
                    if (v == null) {
                        return 1;
                    }
                    return v + 1;
                });
            }
        }

        protected List<Extension> getExtensions(List<TupleExpr> expressions) {
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            for (TupleExpr expr : expressions) {
                if (!(expr instanceof Extension)) continue;
                extensions.add((Extension)expr);
            }
            return extensions;
        }

        protected List<TupleExpr> getSubSelects(List<TupleExpr> expressions) {
            ArrayList<TupleExpr> subselects = new ArrayList<TupleExpr>();
            for (TupleExpr expr : expressions) {
                if (!TupleExprs.containsSubquery((TupleExpr)expr)) continue;
                subselects.add(expr);
            }
            return subselects;
        }

        protected List<TupleExpr> reorderSubselects(List<TupleExpr> subSelects) {
            if (subSelects.size() == 1) {
                return subSelects;
            }
            ArrayList<TupleExpr> result = new ArrayList<TupleExpr>();
            if (subSelects.isEmpty()) {
                return result;
            }
            HashMap joinSizes = new HashMap();
            int maxJoinSize = 0;
            for (int i = 0; i < subSelects.size(); ++i) {
                TupleExpr firstArg = subSelects.get(i);
                for (int j = i + 1; j < subSelects.size(); ++j) {
                    TupleExpr secondArg = subSelects.get(j);
                    Set names = firstArg.getBindingNames();
                    names.retainAll(secondArg.getBindingNames());
                    int joinSize = names.size();
                    if (joinSize > maxJoinSize) {
                        maxJoinSize = joinSize;
                    }
                    List l = joinSizes.containsKey(joinSize) ? (List)joinSizes.get(joinSize) : new ArrayList();
                    TupleExpr[] tupleTuple = new TupleExpr[]{firstArg, secondArg};
                    l.add(tupleTuple);
                    joinSizes.put(joinSize, l);
                }
            }
            TupleExpr[] maxUnionTupleTuple = null;
            int currentUnionSize = -1;
            List list = (List)joinSizes.get(maxJoinSize);
            for (TupleExpr[] tupleTuple : list) {
                Set names = tupleTuple[0].getBindingNames();
                names.addAll(tupleTuple[1].getBindingNames());
                int unionSize = names.size();
                if (unionSize <= currentUnionSize) continue;
                maxUnionTupleTuple = tupleTuple;
                currentUnionSize = unionSize;
            }
            assert (maxUnionTupleTuple != null);
            result.add((TupleExpr)maxUnionTupleTuple[0]);
            result.add((TupleExpr)maxUnionTupleTuple[1]);
            while (result.size() < subSelects.size()) {
                result.add(this.getNextSubselect(result, subSelects));
            }
            return result;
        }

        private TupleExpr getNextSubselect(List<TupleExpr> currentList, List<TupleExpr> joinArgs) {
            HashSet currentListNames = new HashSet();
            for (TupleExpr expr : currentList) {
                currentListNames.addAll(expr.getBindingNames());
            }
            TupleExpr selected = null;
            int currentUnionSize = -1;
            int currentJoinSize = -1;
            for (TupleExpr candidate : joinArgs) {
                if (currentList.contains(candidate)) continue;
                Set names = candidate.getBindingNames();
                names.retainAll(currentListNames);
                int joinSize = names.size();
                names = candidate.getBindingNames();
                names.addAll(currentListNames);
                int unionSize = names.size();
                if (joinSize > currentJoinSize) {
                    selected = candidate;
                    currentJoinSize = joinSize;
                    currentUnionSize = unionSize;
                    continue;
                }
                if (joinSize != currentJoinSize || unionSize <= currentUnionSize) continue;
                selected = candidate;
                currentUnionSize = unionSize;
            }
            return selected;
        }

        protected TupleExpr selectNextTupleExpr(List<TupleExpr> expressions, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap) {
            TupleExpr result = null;
            double lowestCost = Double.POSITIVE_INFINITY;
            for (TupleExpr tupleExpr : expressions) {
                double cost = this.getTupleExprCost(tupleExpr, cardinalityMap, varsMap, varFreqMap);
                if (!(cost < lowestCost) && result != null) continue;
                lowestCost = cost;
                result = tupleExpr;
            }
            assert (result != null);
            result.setCostEstimate(lowestCost);
            return result;
        }

        protected double getTupleExprCost(TupleExpr tupleExpr, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap) {
            double cost = cardinalityMap.get(tupleExpr);
            List<Var> vars = varsMap.get(tupleExpr);
            List<Var> unboundVars = this.getUnboundVars(vars);
            int constantVars = this.countConstantVars(vars);
            int nonConstantVarCount = vars.size() - constantVars;
            if (nonConstantVarCount > 0) {
                double exp = (double)unboundVars.size() / (double)nonConstantVarCount;
                cost = Math.pow(cost, exp);
            }
            if (unboundVars.isEmpty()) {
                if (nonConstantVarCount > 0) {
                    cost /= (double)nonConstantVarCount;
                }
            } else {
                int foreignVarFreq = this.getForeignVarFreq(unboundVars, varFreqMap);
                if (foreignVarFreq > 0) {
                    cost /= (double)(1 + foreignVarFreq);
                }
            }
            if (tupleExpr instanceof BindingSetAssignment) {
                Set<Var> varsUsedInOtherExpressions = varFreqMap.keySet();
                for (String assuredBindingName : tupleExpr.getAssuredBindingNames()) {
                    if (!varsUsedInOtherExpressions.contains(new Var(assuredBindingName))) continue;
                    cost = 0.0;
                    break;
                }
            }
            return cost;
        }

        private int countConstantVars(List<Var> vars) {
            int size = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++size;
            }
            return size;
        }

        protected List<Var> getUnboundVars(Iterable<Var> vars) {
            List<Var> ret = null;
            for (Var var : vars) {
                if (var.hasValue() || var.getName() == null || this.boundVars.contains(var.getName())) continue;
                if (ret == null) {
                    ret = Collections.singletonList(var);
                    continue;
                }
                if (ret.size() == 1) {
                    ret = new ArrayList<Var>(ret);
                }
                ret.add(var);
            }
            return ret != null ? ret : Collections.emptyList();
        }

        protected int getForeignVarFreq(List<Var> ownUnboundVars, Map<Var, Integer> varFreqMap) {
            if (ownUnboundVars.isEmpty()) {
                return 0;
            }
            if (ownUnboundVars.size() == 1) {
                return varFreqMap.get(ownUnboundVars.get(0)) - 1;
            }
            int result = -ownUnboundVars.size();
            for (Var var : new HashSet<Var>(ownUnboundVars)) {
                result += varFreqMap.get(var).intValue();
            }
            return result;
        }

        private static class StatementPatternVarCollector
        extends StatementPatternVisitor {
            private final TupleExpr tupleExpr;
            private List<Var> vars;

            public StatementPatternVarCollector(TupleExpr tupleExpr) {
                this.tupleExpr = tupleExpr;
            }

            protected void accept(StatementPattern node) {
                if (this.vars == null) {
                    this.vars = new ArrayList<Var>(node.getVarList());
                } else {
                    this.vars.addAll(node.getVarList());
                }
            }

            public List<Var> getVars() {
                if (this.vars == null) {
                    try {
                        this.tupleExpr.visit((QueryModelVisitor)this);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    if (this.vars == null) {
                        this.vars = Collections.emptyList();
                    }
                }
                return this.vars;
            }
        }
    }
}

