/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.RDFStarTripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;

public class RdfStarQueryEvaluationStep
implements QueryEvaluationStep {
    private final Var extVar;
    private final Var predVar;
    private final Var objVar;
    private final Var subjVar;
    private final RDFStarTripleSource tripleSource;
    private final QueryEvaluationContext context;

    public RdfStarQueryEvaluationStep(Var subjVar, Var predVar, Var objVar, Var extVar, RDFStarTripleSource tripleSource, QueryEvaluationContext context) {
        this.extVar = extVar;
        this.predVar = predVar;
        this.objVar = objVar;
        this.subjVar = subjVar;
        this.tripleSource = tripleSource;
        this.context = context;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final BindingSet bindings) {
        final Value subjValue = StrictEvaluationStrategy.getVarValue(this.subjVar, bindings);
        final Value predValue = StrictEvaluationStrategy.getVarValue(this.predVar, bindings);
        final Value objValue = StrictEvaluationStrategy.getVarValue(this.objVar, bindings);
        final Value extValue = StrictEvaluationStrategy.getVarValue(this.extVar, bindings);
        if (extValue != null && !(extValue instanceof Resource)) {
            return EMPTY_ITERATION;
        }
        CloseableIteration<? extends Triple, QueryEvaluationException> sourceIter = this.tripleSource.getRdfStarTriples((Resource)subjValue, (IRI)predValue, objValue);
        FilterIteration<Triple, QueryEvaluationException> filterIter = new FilterIteration<Triple, QueryEvaluationException>(sourceIter){

            @Override
            protected boolean accept(Triple triple) throws QueryEvaluationException {
                if (subjValue != null && !subjValue.equals(triple.getSubject())) {
                    return false;
                }
                if (predValue != null && !predValue.equals(triple.getPredicate())) {
                    return false;
                }
                if (objValue != null && !objValue.equals(triple.getObject())) {
                    return false;
                }
                return extValue == null || extValue.equals(triple);
            }
        };
        return new ConvertingIteration<Triple, BindingSet, QueryEvaluationException>((Iteration)filterIter){

            @Override
            protected BindingSet convert(Triple triple) throws QueryEvaluationException {
                MutableBindingSet result = RdfStarQueryEvaluationStep.this.context.createBindingSet(bindings);
                if (subjValue == null) {
                    result.addBinding(RdfStarQueryEvaluationStep.this.subjVar.getName(), triple.getSubject());
                }
                if (predValue == null) {
                    result.addBinding(RdfStarQueryEvaluationStep.this.predVar.getName(), triple.getPredicate());
                }
                if (objValue == null) {
                    result.addBinding(RdfStarQueryEvaluationStep.this.objVar.getName(), triple.getObject());
                }
                if (extValue == null) {
                    result.addBinding(RdfStarQueryEvaluationStep.this.extVar.getName(), triple);
                }
                return result;
            }
        };
    }
}

