/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.config;

import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.eclipse.rdf4j.sail.nativerdf.config.NativeStoreConfig;

public class NativeStoreFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:NativeStore";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new NativeStoreConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        NativeStore nativeStore = new NativeStore();
        if (config instanceof NativeStoreConfig) {
            EvaluationStrategyFactory evalStratFactory;
            NativeStoreConfig nativeConfig = (NativeStoreConfig)config;
            nativeStore.setTripleIndexes(nativeConfig.getTripleIndexes());
            nativeStore.setForceSync(nativeConfig.getForceSync());
            if (nativeConfig.getValueCacheSize() >= 0) {
                nativeStore.setValueCacheSize(nativeConfig.getValueCacheSize());
            }
            if (nativeConfig.getValueIDCacheSize() >= 0) {
                nativeStore.setValueIDCacheSize(nativeConfig.getValueIDCacheSize());
            }
            if (nativeConfig.getNamespaceCacheSize() >= 0) {
                nativeStore.setNamespaceCacheSize(nativeConfig.getNamespaceCacheSize());
            }
            if (nativeConfig.getNamespaceIDCacheSize() >= 0) {
                nativeStore.setNamespaceIDCacheSize(nativeConfig.getNamespaceIDCacheSize());
            }
            if (nativeConfig.getIterationCacheSyncThreshold() > 0L) {
                nativeStore.setIterationCacheSyncThreshold(nativeConfig.getIterationCacheSyncThreshold());
            }
            if ((evalStratFactory = nativeConfig.getEvaluationStrategyFactory()) != null) {
                nativeStore.setEvaluationStrategyFactory(evalStratFactory);
            }
        }
        return nativeStore;
    }
}

