/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.Changeset;
import org.eclipse.rdf4j.sail.base.SailClosable;

public interface SailSink
extends SailClosable {
    public void prepare() throws SailException;

    public void flush() throws SailException;

    public void setNamespace(String var1, String var2) throws SailException;

    public void removeNamespace(String var1) throws SailException;

    public void clearNamespaces() throws SailException;

    public void clear(Resource ... var1) throws SailException;

    public void observe(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    default public void observe(Resource subj, IRI pred, Value obj, Resource context) throws SailException {
        this.observe(subj, pred, obj, new Resource[]{context});
    }

    public void approve(Resource var1, IRI var2, Value var3, Resource var4) throws SailException;

    default public void approve(Statement statement) throws SailException {
        this.approve(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext());
    }

    @Deprecated(since="3.1.0")
    default public void deprecate(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
        this.deprecate(SimpleValueFactory.getInstance().createStatement(subj, pred, obj, ctx));
    }

    public void deprecate(Statement var1) throws SailException;

    default public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        throw new UnsupportedOperationException();
    }

    default public boolean supportsDeprecateByQuery() {
        return false;
    }

    default public void approveAll(Set<Statement> approved, Set<Resource> approvedContexts) {
        for (Statement statement : approved) {
            this.approve(statement);
        }
    }

    default public void deprecateAll(Set<Statement> deprecated) {
        for (Statement statement : deprecated) {
            this.deprecate(statement);
        }
    }

    default public void observeAll(Set<Changeset.SimpleStatementPattern> observed) {
        for (Changeset.SimpleStatementPattern p : observed) {
            Resource subj = p.getSubject();
            IRI pred = p.getPredicate();
            Value obj = p.getObject();
            Resource context = p.getContext();
            if (p.isAllContexts()) {
                this.observe(subj, pred, obj, new Resource[0]);
                continue;
            }
            this.observe(subj, pred, obj, context);
        }
    }
}

