/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.contextaware.config;

import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.config.AbstractDelegatingRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.contextaware.config.ContextAwareSchema;

public class ContextAwareConfig
extends AbstractDelegatingRepositoryImplConfig {
    private static final IRI[] ALL_CONTEXTS = new IRI[0];
    private Boolean includeInferred = true;
    private int maxQueryTime = 0;
    private QueryLanguage queryLanguage = QueryLanguage.SPARQL;
    private String baseURI;
    private IRI[] readContexts = ALL_CONTEXTS;
    private IRI[] addContexts = ALL_CONTEXTS;
    private IRI[] removeContexts = ALL_CONTEXTS;
    private IRI[] archiveContexts = ALL_CONTEXTS;
    private IRI insertContext = null;

    public ContextAwareConfig() {
        super("openrdf:ContextAwareRepository");
    }

    public int getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
    }

    @Deprecated
    public IRI[] getAddContexts() {
        return this.addContexts;
    }

    @Deprecated
    public IRI[] getArchiveContexts() {
        return this.archiveContexts;
    }

    public IRI getInsertContext() {
        return this.insertContext;
    }

    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public IRI[] getReadContexts() {
        return this.readContexts;
    }

    public IRI[] getRemoveContexts() {
        return this.removeContexts;
    }

    public boolean isIncludeInferred() {
        return this.includeInferred == null || this.includeInferred != false;
    }

    @Deprecated
    public void setAddContexts(IRI ... addContexts) {
        this.addContexts = addContexts;
    }

    @Deprecated
    public void setArchiveContexts(IRI ... archiveContexts) {
        this.archiveContexts = archiveContexts;
    }

    public void setInsertContext(IRI insertContext) {
        this.insertContext = insertContext;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public void setQueryLanguage(QueryLanguage ql) {
        this.queryLanguage = ql;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public void setReadContexts(IRI ... readContexts) {
        this.readContexts = readContexts;
    }

    public void setRemoveContexts(IRI ... removeContexts) {
        this.removeContexts = removeContexts;
    }

    public Resource export(Model model) {
        Resource repImplNode = super.export(model);
        if (this.includeInferred != null) {
            model.add(repImplNode, CONFIG.ContextAware.includeInferred, (Value)Values.literal((Object)this.includeInferred), new Resource[0]);
            model.add(repImplNode, ContextAwareSchema.INCLUDE_INFERRED, (Value)Values.literal((Object)this.includeInferred), new Resource[0]);
        }
        if (this.maxQueryTime > 0) {
            model.add(repImplNode, CONFIG.ContextAware.maxQueryTime, (Value)Values.literal((int)this.maxQueryTime), new Resource[0]);
            model.add(repImplNode, ContextAwareSchema.MAX_QUERY_TIME, (Value)Values.literal((int)this.maxQueryTime), new Resource[0]);
        }
        if (this.queryLanguage != null) {
            model.add(repImplNode, CONFIG.ContextAware.queryLanguage, (Value)Values.literal((String)this.queryLanguage.getName()), new Resource[0]);
            model.add(repImplNode, ContextAwareSchema.QUERY_LANGUAGE, (Value)Values.literal((String)this.queryLanguage.getName()), new Resource[0]);
        }
        if (this.baseURI != null) {
            model.add(repImplNode, CONFIG.ContextAware.base, (Value)Values.iri((String)this.baseURI), new Resource[0]);
            model.add(repImplNode, ContextAwareSchema.BASE_URI, (Value)Values.iri((String)this.baseURI), new Resource[0]);
        }
        for (IRI uri : this.readContexts) {
            model.add(repImplNode, CONFIG.ContextAware.readContext, (Value)uri, new Resource[0]);
            model.add(repImplNode, ContextAwareSchema.READ_CONTEXT, (Value)uri, new Resource[0]);
        }
        for (IRI resource : this.addContexts) {
            model.add(repImplNode, ContextAwareSchema.ADD_CONTEXT, (Value)resource, new Resource[0]);
        }
        for (IRI resource : this.removeContexts) {
            model.add(repImplNode, CONFIG.ContextAware.removeContext, (Value)resource, new Resource[0]);
            model.add(repImplNode, ContextAwareSchema.REMOVE_CONTEXT, (Value)resource, new Resource[0]);
        }
        for (IRI resource : this.archiveContexts) {
            model.add(repImplNode, ContextAwareSchema.ARCHIVE_CONTEXT, (Value)resource, new Resource[0]);
        }
        if (this.insertContext != null) {
            model.add(repImplNode, CONFIG.ContextAware.insertContext, (Value)this.insertContext, new Resource[0]);
            model.add(repImplNode, ContextAwareSchema.INSERT_CONTEXT, (Value)this.insertContext, new Resource[0]);
        }
        return repImplNode;
    }

    public void parse(Model model, Resource resource) throws RepositoryConfigException {
        super.parse(model, resource);
        try {
            Configurations.getLiteralValue((Model)model, (Resource)resource, (IRI)CONFIG.ContextAware.includeInferred, (IRI)ContextAwareSchema.INCLUDE_INFERRED).ifPresent(lit -> this.setIncludeInferred(lit.booleanValue()));
            Configurations.getLiteralValue((Model)model, (Resource)resource, (IRI)CONFIG.ContextAware.maxQueryTime, (IRI)ContextAwareSchema.MAX_QUERY_TIME).ifPresent(lit -> this.setMaxQueryTime(lit.intValue()));
            Configurations.getLiteralValue((Model)model, (Resource)resource, (IRI)CONFIG.ContextAware.queryLanguage, (IRI)ContextAwareSchema.QUERY_LANGUAGE).ifPresent(lit -> this.setQueryLanguage(QueryLanguage.valueOf((String)lit.getLabel())));
            Configurations.getIRIValue((Model)model, (Resource)resource, (IRI)CONFIG.ContextAware.base, (IRI)ContextAwareSchema.BASE_URI).ifPresent(iri -> this.setBaseURI(iri.stringValue()));
            Set objects = Configurations.getPropertyValues((Model)model, (Resource)resource, (IRI)CONFIG.ContextAware.readContext, (IRI)ContextAwareSchema.READ_CONTEXT);
            this.setReadContexts(objects.toArray(new IRI[objects.size()]));
            objects = model.filter(resource, ContextAwareSchema.ADD_CONTEXT, null, new Resource[0]).objects();
            this.setAddContexts(objects.toArray(new IRI[objects.size()]));
            objects = Configurations.getPropertyValues((Model)model, (Resource)resource, (IRI)CONFIG.ContextAware.removeContext, (IRI)ContextAwareSchema.REMOVE_CONTEXT);
            this.setRemoveContexts(objects.toArray(new IRI[objects.size()]));
            objects = model.filter(resource, ContextAwareSchema.ARCHIVE_CONTEXT, null, new Resource[0]).objects();
            this.setArchiveContexts(objects.toArray(new IRI[objects.size()]));
            Configurations.getIRIValue((Model)model, (Resource)resource, (IRI)CONFIG.ContextAware.insertContext, (IRI)ContextAwareSchema.INSERT_CONTEXT).ifPresent(iri -> this.setInsertContext((IRI)iri));
        }
        catch (ArrayStoreException e) {
            throw new RepositoryConfigException((Throwable)e);
        }
    }
}

