/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingletonBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlConstraintSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(SparqlConstraintSelect.class);
    private final SailConnection connection;
    private final PlanNode targets;
    private final String query;
    private final Resource[] dataGraph;
    private final boolean produceValidationReports;
    private final ConstraintComponent constraintComponent;
    private final Shape shape;
    private final String[] variables;
    private final ConstraintComponent.Scope scope;
    private final Dataset dataset;
    private final ParsedQuery parsedQuery;
    private final boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public SparqlConstraintSelect(SailConnection connection, PlanNode targets, String query, ConstraintComponent.Scope scope, Resource[] dataGraph, boolean produceValidationReports, ConstraintComponent constraintComponent, Shape shape) {
        this.connection = connection;
        this.targets = targets;
        this.query = query;
        this.dataGraph = dataGraph;
        this.produceValidationReports = produceValidationReports;
        this.constraintComponent = constraintComponent;
        this.shape = shape;
        assert (query.contains("$this")) : "Query should contain $this: " + query;
        this.variables = new String[]{"$this"};
        this.scope = scope;
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
        try {
            this.parsedQuery = queryParserFactory.getParser().parseQuery(query, null);
        }
        catch (MalformedQueryException e) {
            logger.error("Malformed query: \n{}", (Object)query);
            throw e;
        }
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends BindingSet> results;
            CloseableIteration<? extends ValidationTuple> targetIterator;
            ValidationTuple next;
            ValidationTuple nextTarget;

            @Override
            protected void init() {
                assert (this.targetIterator == null);
                this.targetIterator = SparqlConstraintSelect.this.targets.iterator();
            }

            private void calculateNext() {
                while (this.next == null && (this.targetIterator.hasNext() || this.results != null && this.results.hasNext())) {
                    if (this.results == null && this.targetIterator.hasNext()) {
                        this.nextTarget = (ValidationTuple)this.targetIterator.next();
                        SingletonBindingSet bindings = new SingletonBindingSet("this", this.nextTarget.getActiveTarget());
                        this.results = SparqlConstraintSelect.this.connection.evaluate(SparqlConstraintSelect.this.parsedQuery.getTupleExpr(), SparqlConstraintSelect.this.dataset, (BindingSet)bindings, true);
                    }
                    if (this.results.hasNext()) {
                        BindingSet bindingSet = (BindingSet)this.results.next();
                        Value value = bindingSet.getValue("value");
                        Value path = bindingSet.getValue("path");
                        if (SparqlConstraintSelect.this.scope == ConstraintComponent.Scope.nodeShape && SparqlConstraintSelect.this.produceValidationReports) {
                            this.next = this.nextTarget.addValidationResult(t -> {
                                ValidationResult validationResult = new ValidationResult(t.getActiveTarget(), value, SparqlConstraintSelect.this.shape, SparqlConstraintSelect.this.constraintComponent, SparqlConstraintSelect.this.shape.getSeverity(), ConstraintComponent.Scope.nodeShape, t.getContexts(), SparqlConstraintSelect.this.shape.getContexts());
                                validationResult.setPathIri(path);
                                return validationResult;
                            });
                            continue;
                        }
                        ValidationTuple validationTuple = new ValidationTuple(this.nextTarget.getActiveTarget(), value, SparqlConstraintSelect.this.scope, true, this.nextTarget.getContexts());
                        this.next = ValidationTupleHelper.join(this.nextTarget, validationTuple);
                        continue;
                    }
                    this.results.close();
                    this.results = null;
                }
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void localClose() {
                try {
                    if (this.targetIterator != null) {
                        this.targetIterator.close();
                    }
                }
                finally {
                    if (this.results != null) {
                        this.results.close();
                    }
                }
            }
        };
    }

    @Override
    public int depth() {
        return this.targets.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "SparqlConstraintSelect{targets=" + this.targets + ", query='" + this.query.replace("\n", "  ") + "', dataGraph=" + Arrays.toString(this.dataGraph) + ", scope=" + this.scope + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparqlConstraintSelect that = (SparqlConstraintSelect)o;
        if (this.scope != that.scope) {
            return false;
        }
        if (!this.targets.equals(that.targets)) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        if (!Arrays.equals(this.dataGraph, that.dataGraph)) {
            return false;
        }
        if (!Arrays.equals(this.variables, that.variables)) {
            return false;
        }
        return Objects.equals(this.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)this.connection).getSail() : this.connection, that.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)that.connection).getSail() : that.connection);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            int result = ((MemoryStoreConnection)this.connection).getSail().hashCode();
            result = 31 * result + this.targets.hashCode();
            result = 31 * result + this.query.hashCode();
            result = 31 * result + Arrays.hashCode(this.dataGraph);
            result = 31 * result + Arrays.hashCode(this.variables);
            result = 31 * result + this.scope.hashCode();
            return result;
        }
        int result = this.connection.hashCode();
        result = 31 * result + this.targets.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Arrays.hashCode(this.dataGraph);
        result = 31 * result + Arrays.hashCode(this.variables);
        result = 31 * result + this.scope.hashCode();
        return result;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.targets.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

