/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ArrayBindingBasedQueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SimpleBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingletonBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetChainRetriever
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(TargetChainRetriever.class);
    private static final int BULK_SIZE = 1000;
    private final ConnectionsGroup connectionsGroup;
    private final List<StatementMatcher> statementMatchers;
    private final List<StatementMatcher> removedStatementMatchers;
    private final String queryFragment;
    private final QueryParserFactory queryParserFactory;
    private final ConstraintComponent.Scope scope;
    private final Resource[] dataGraph;
    private final Dataset dataset;
    private final Set<String> varNames;
    private final String sparqlProjection;
    private final EffectiveTarget.EffectiveTargetFragment removedStatementTarget;
    private final boolean hasValue;
    private final Set<String> varNamesInQueryFragment;
    private StackTraceElement[] stackTrace;
    private ValidationExecutionLogger validationExecutionLogger;

    public TargetChainRetriever(ConnectionsGroup connectionsGroup, Resource[] dataGraph, List<StatementMatcher> statementMatchers, List<StatementMatcher> removedStatementMatchers, EffectiveTarget.EffectiveTargetFragment removedStatementTarget, SparqlFragment queryFragment, List<StatementMatcher.Variable<Value>> vars, ConstraintComponent.Scope scope, boolean hasValue) {
        this.connectionsGroup = connectionsGroup;
        this.dataGraph = dataGraph;
        this.varNames = vars.stream().map(StatementMatcher.Variable::getName).collect(Collectors.toSet());
        assert (!this.varNames.isEmpty());
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(this.dataGraph);
        this.statementMatchers = StatementMatcher.reduce(statementMatchers);
        this.scope = scope;
        this.sparqlProjection = vars.stream().map(StatementMatcher.Variable::asSparqlVariable).reduce((a, b) -> a + " " + b).orElseThrow(IllegalStateException::new);
        this.queryFragment = queryFragment.getNamespacesForSparql() + StatementMatcher.StableRandomVariableProvider.normalize(queryFragment.getFragment());
        this.queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
        this.varNamesInQueryFragment = Set.of(ArrayBindingBasedQueryEvaluationContext.findAllVariablesUsedInQuery((QueryRoot)((QueryRoot)this.queryParserFactory.getParser().parseQuery("select * where {\n" + this.queryFragment + "\n}", null).getTupleExpr())));
        assert (!this.varNamesInQueryFragment.isEmpty());
        this.removedStatementMatchers = removedStatementMatchers != null ? StatementMatcher.reduce(removedStatementMatchers) : Collections.emptyList();
        this.removedStatementTarget = removedStatementTarget;
        this.hasValue = hasValue;
        assert (scope == ConstraintComponent.Scope.propertyShape || !this.hasValue);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private final Iterator<StatementMatcher> statementPatternIterator;
            private final Iterator<StatementMatcher> removedStatementIterator;
            private StatementMatcher currentStatementMatcher;
            private String sparqlValuesDecl;
            private Set<String> currentVarNames;
            private CloseableIteration<? extends Statement> statements;
            private ValidationTuple next;
            private CloseableIteration<? extends BindingSet> results;
            private ParsedQuery parsedQuery;
            private boolean removedStatement;
            private final List<BindingSet> bulk;
            {
                this.statementPatternIterator = TargetChainRetriever.this.statementMatchers.iterator();
                this.removedStatementIterator = TargetChainRetriever.this.removedStatementMatchers.iterator();
                this.removedStatement = false;
                this.bulk = new ArrayList<BindingSet>(1000);
            }

            @Override
            protected void init() {
            }

            public void calculateNextStatementMatcher() {
                if (this.statements != null && this.statements.hasNext()) {
                    return;
                }
                if (!this.statementPatternIterator.hasNext() && !this.removedStatementIterator.hasNext()) {
                    if (this.statements != null) {
                        this.statements.close();
                        this.statements = null;
                    }
                    return;
                }
                do {
                    SailConnection connection;
                    if (this.statements != null) {
                        this.statements.close();
                        this.statements = null;
                    }
                    if (!this.statementPatternIterator.hasNext() && !this.removedStatementIterator.hasNext()) break;
                    if (this.statementPatternIterator.hasNext()) {
                        this.currentStatementMatcher = this.statementPatternIterator.next();
                        connection = TargetChainRetriever.this.connectionsGroup.getAddedStatements();
                        this.removedStatement = false;
                    } else {
                        if (!TargetChainRetriever.this.connectionsGroup.getStats().hasRemoved()) break;
                        this.currentStatementMatcher = this.removedStatementIterator.next();
                        connection = TargetChainRetriever.this.connectionsGroup.getRemovedStatements();
                        this.removedStatement = true;
                    }
                    this.sparqlValuesDecl = this.currentStatementMatcher.getSparqlValuesDecl(TargetChainRetriever.this.varNames, this.removedStatement, TargetChainRetriever.this.varNamesInQueryFragment);
                    this.currentVarNames = this.currentStatementMatcher.getVarNames(TargetChainRetriever.this.varNames, this.removedStatement, TargetChainRetriever.this.varNamesInQueryFragment);
                    assert (!this.currentVarNames.isEmpty());
                    this.statements = connection.getStatements(this.currentStatementMatcher.getSubjectValue(), this.currentStatementMatcher.getPredicateValue(), this.currentStatementMatcher.getObjectValue(), false, TargetChainRetriever.this.dataGraph);
                } while (!this.statements.hasNext());
                this.parsedQuery = null;
            }

            private void calculateNextResult() {
                if (this.next != null) {
                    return;
                }
                while (this.results == null || !this.results.hasNext()) {
                    try {
                        if (this.results != null) {
                            this.results.close();
                            this.results = null;
                        }
                        while (this.statements == null || !this.statements.hasNext()) {
                            this.calculateNextStatementMatcher();
                            if (this.statements != null) continue;
                            return;
                        }
                        if (this.parsedQuery == null) {
                            String query = "select " + TargetChainRetriever.this.sparqlProjection + " where {\n" + this.sparqlValuesDecl + TargetChainRetriever.this.queryFragment + "\n}";
                            this.parsedQuery = TargetChainRetriever.this.queryParserFactory.getParser().parseQuery(query, null);
                        }
                        List<BindingSet> bulk = this.readStatementsInBulk(this.currentVarNames);
                        this.setBindings(this.currentVarNames, bulk);
                        this.results = TargetChainRetriever.this.connectionsGroup.getBaseConnection().evaluate(this.parsedQuery.getTupleExpr(), TargetChainRetriever.this.dataset, EmptyBindingSet.getInstance(), true);
                    }
                    catch (MalformedQueryException e) {
                        logger.error("Malformed query:\n{}", (Object)TargetChainRetriever.this.queryFragment);
                        throw e;
                    }
                }
                if (this.results.hasNext()) {
                    BindingSet nextBinding = (BindingSet)this.results.next();
                    if (nextBinding.size() == 1) {
                        Iterator iterator = nextBinding.iterator();
                        this.next = iterator.hasNext() ? new ValidationTuple(((Binding)iterator.next()).getValue(), TargetChainRetriever.this.scope, TargetChainRetriever.this.hasValue, TargetChainRetriever.this.dataGraph) : new ValidationTuple((Value)null, TargetChainRetriever.this.scope, TargetChainRetriever.this.hasValue, TargetChainRetriever.this.dataGraph);
                    } else {
                        Value[] values = (Value[])StreamSupport.stream(nextBinding.spliterator(), false).sorted(Comparator.comparing(Binding::getName)).map(Binding::getValue).toArray(Value[]::new);
                        this.next = new ValidationTuple(values, TargetChainRetriever.this.scope, TargetChainRetriever.this.hasValue, TargetChainRetriever.this.dataGraph);
                    }
                }
            }

            private List<BindingSet> readStatementsInBulk(Set<String> varNames) {
                this.bulk.clear();
                while (this.bulk.size() < 1000 && this.statements.hasNext()) {
                    Stream<EffectiveTarget.StatementsAndMatcher> root;
                    Statement next = (Statement)this.statements.next();
                    Stream<EffectiveTarget.StatementsAndMatcher> rootStatements = Stream.of(new EffectiveTarget.StatementsAndMatcher(List.of(next), this.currentStatementMatcher));
                    if (this.removedStatement && (root = TargetChainRetriever.this.removedStatementTarget.getRoot(TargetChainRetriever.this.connectionsGroup, TargetChainRetriever.this.dataGraph, this.currentStatementMatcher, next)) != null) {
                        rootStatements = root;
                    }
                    rootStatements.filter(EffectiveTarget.StatementsAndMatcher::hasStatements).flatMap(statementsAndMatcher -> {
                        StatementMatcher newCurrentStatementMatcher = statementsAndMatcher.getStatementMatcher();
                        return statementsAndMatcher.getStatements().stream().map(temp -> {
                            Binding[] bindings = new Binding[varNames.size()];
                            int j = 0;
                            if (newCurrentStatementMatcher.getSubjectValue() == null && this.currentVarNames.contains(newCurrentStatementMatcher.getSubjectName())) {
                                bindings[j++] = new SimpleBinding(newCurrentStatementMatcher.getSubjectName(), (Value)temp.getSubject());
                            }
                            if (newCurrentStatementMatcher.getPredicateValue() == null && this.currentVarNames.contains(newCurrentStatementMatcher.getPredicateName())) {
                                bindings[j++] = new SimpleBinding(newCurrentStatementMatcher.getPredicateName(), (Value)temp.getPredicate());
                            }
                            if (newCurrentStatementMatcher.getObjectValue() == null && this.currentVarNames.contains(newCurrentStatementMatcher.getObjectName())) {
                                bindings[j++] = new SimpleBinding(newCurrentStatementMatcher.getObjectName(), temp.getObject());
                            }
                            if (bindings.length == 1) {
                                return new SingletonBindingSet(bindings[0].getName(), bindings[0].getValue());
                            }
                            return new SimpleBindingSet(varNames, bindings);
                        });
                    }).distinct().forEach(this.bulk::add);
                }
                return this.bulk;
            }

            private void setBindings(final Set<String> varNames, final List<BindingSet> bulk) {
                this.parsedQuery.getTupleExpr().visit((QueryModelVisitor)new AbstractSimpleQueryModelVisitor<RuntimeException>(false){

                    public void meet(BindingSetAssignment node) {
                        Set bindingNames = node.getBindingNames();
                        if (bindingNames.equals(varNames)) {
                            node.setBindingSets((Iterable)bulk);
                        }
                        super.meet(node);
                    }
                });
            }

            @Override
            public void localClose() {
                try {
                    if (this.statements != null) {
                        this.statements.close();
                    }
                }
                finally {
                    if (this.results != null) {
                        this.results.close();
                    }
                }
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNextResult();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNextResult();
                return this.next != null;
            }
        };
    }

    private static boolean bindingsEquivalent(StatementMatcher currentStatementMatcher, MapBindingSet bindings, MapBindingSet previousBindings) {
        if (currentStatementMatcher == null || bindings == null || previousBindings == null) {
            return false;
        }
        boolean equivalent = true;
        if (equivalent && currentStatementMatcher.getSubjectValue() == null && !currentStatementMatcher.subjectIsWildcard()) {
            equivalent = Objects.equals(bindings.getBinding(currentStatementMatcher.getSubjectName()), previousBindings.getBinding(currentStatementMatcher.getSubjectName()));
        }
        if (equivalent && currentStatementMatcher.getPredicateValue() == null && !currentStatementMatcher.predicateIsWildcard()) {
            equivalent = Objects.equals(bindings.getBinding(currentStatementMatcher.getPredicateName()), previousBindings.getBinding(currentStatementMatcher.getPredicateName()));
        }
        if (equivalent && currentStatementMatcher.getObjectValue() == null && !currentStatementMatcher.objectIsWildcard()) {
            equivalent = Objects.equals(bindings.getBinding(currentStatementMatcher.getObjectName()), previousBindings.getBinding(currentStatementMatcher.getObjectName()));
        }
        return equivalent;
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetChainRetriever that = (TargetChainRetriever)o;
        return this.statementMatchers.equals(that.statementMatchers) && this.removedStatementMatchers.equals(that.removedStatementMatchers) && this.queryFragment.equals(that.queryFragment) && Objects.equals(this.dataset, that.dataset) && this.scope == that.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statementMatchers, this.removedStatementMatchers, this.queryFragment, this.scope, this.dataset});
    }

    public String toString() {
        return "TargetChainRetriever{statementPatterns=" + this.statementMatchers + ", removedStatementMatchers=" + this.removedStatementMatchers + ", query='" + this.queryFragment.replace("\n", "\t") + "', scope=" + this.scope + "}";
    }
}

