/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.datetime;

import java.math.BigDecimal;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Seconds
implements Function {
    @Override
    public String getURI() {
        return FN.SECONDS_FROM_DATETIME.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("SECONDS requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype != null && datatype.isCalendarDatatype()) {
                try {
                    XMLGregorianCalendar calValue = literal.calendarValue();
                    int seconds = calValue.getSecond();
                    if (Integer.MIN_VALUE != seconds) {
                        BigDecimal fraction = calValue.getFractionalSecond();
                        String str = fraction == null ? String.valueOf(seconds) : String.valueOf(fraction.doubleValue() + (double)seconds);
                        return valueFactory.createLiteral(str, (CoreDatatype)CoreDatatype.XSD.DECIMAL);
                    }
                    throw new ValueExprEvaluationException("can not determine minutes from value: " + argValue);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueExprEvaluationException("illegal calendar value: " + argValue);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

