/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.Iterator;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class BindingSetAssignmentInlinerOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        BindingSetAssignmentVisitor visitor = new BindingSetAssignmentVisitor();
        tupleExpr.visit(visitor);
    }

    private static class BindingSetAssignmentVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private BindingSet bindingSet;

        private BindingSetAssignmentVisitor() {
        }

        @Override
        public void meet(BindingSetAssignment bsa) {
            Iterator<BindingSet> iter = bsa.getBindingSets().iterator();
            if (iter.hasNext()) {
                BindingSet firstBindingSet = iter.next();
                if (!iter.hasNext()) {
                    this.bindingSet = firstBindingSet;
                }
            }
            super.meet(bsa);
        }

        @Override
        public void meet(Service node) throws RuntimeException {
        }

        @Override
        public void meet(Var var) {
            if (this.bindingSet != null && this.bindingSet.hasBinding(var.getName())) {
                Value replacementValue = this.bindingSet.getValue(var.getName());
                var.replaceWith(new Var(var.getName(), replacementValue, var.isAnonymous(), var.isConstant()));
            }
        }

        @Override
        public void meet(Filter node) throws RuntimeException {
            super.meet(node);
        }

        @Override
        public void meet(LeftJoin leftJoin) {
            leftJoin.getLeftArg().visit(this);
        }

        @Override
        protected void meetNode(QueryModelNode node) throws RuntimeException {
            if (node instanceof AbstractQueryModelNode && ((AbstractQueryModelNode)node).isVariableScopeChange()) {
                this.bindingSet = null;
            }
            super.meetNode(node);
        }
    }
}

