/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSelectionProviderAction;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.part.MarkerTransfer;

public class ActionPasteMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private String[] pastableTypes;
    private String markerName;

    public ActionPasteMarker(IWorkbenchPart part, ISelectionProvider provider, String markerName) {
        super(provider, MarkerMessages.pasteAction_title);
        this.part = part;
        this.pastableTypes = new String[0];
        this.markerName = markerName;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.clipboard.getContents((Transfer)transfer);
        this.paste(markerData);
    }

    void paste(final IMarker[] markers) {
        if (markers == null) {
            return;
        }
        final ArrayList newMarkerTypes = new ArrayList();
        final ArrayList newMarkerAttributes = new ArrayList();
        final ArrayList newMarkerResources = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        newMarkerTypes.add(marker.getType());
                        newMarkerResources.add(marker.getResource());
                        newMarkerAttributes.add(marker.getAttributes());
                        ++n2;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)MarkerMessages.PasteMarker_errorTitle, null, (IStatus)e.getStatus());
            return;
        }
        String[] types = newMarkerTypes.toArray(new String[newMarkerTypes.size()]);
        Map[] attrs = newMarkerAttributes.toArray(new Map[newMarkerAttributes.size()]);
        IResource[] resources = newMarkerResources.toArray(new IResource[newMarkerResources.size()]);
        String operationTitle = NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object)MarkerMessages.pasteAction_title, (Object)this.markerName);
        final CreateMarkersOperation op = new CreateMarkersOperation(types, attrs, resources, operationTitle);
        this.execute((IUndoableOperation)op, MarkerMessages.PasteMarker_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.part.getSite().getShell()));
        if (this.getSelectionProvider() != null && op.getMarkers() != null) {
            this.part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ActionPasteMarker.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object[])op.getMarkers()));
                }
            });
        }
    }

    void updateEnablement() {
        this.setEnabled(false);
        if (this.clipboard == null) {
            return;
        }
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.clipboard.getContents((Transfer)transfer);
        if (markerData == null || markerData.length < 1 || this.pastableTypes == null) {
            return;
        }
        IMarker[] iMarkerArray = markerData;
        int n = markerData.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                if (!marker.exists()) break;
                boolean pastable = false;
                String[] stringArray = this.pastableTypes;
                int n3 = this.pastableTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String pastableType = stringArray[n4];
                    if (marker.isSubtypeOf(pastableType)) {
                        pastable = true;
                        break;
                    }
                    ++n4;
                }
                if (!pastable) {
                    return;
                }
                if (!Util.isEditable(marker)) {
                    return;
                }
            }
            catch (CoreException e) {
                return;
            }
            ++n2;
        }
        this.setEnabled(true);
    }

    void setPastableTypes(String[] strings) {
        this.pastableTypes = strings;
    }
}

