/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.internal.xpand2.pr.ProtectedRegionResolver;
import org.eclipse.internal.xpand2.pr.ProtectedRegionResolverImpl;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.XpandEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.util.XtendXpandUtil;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.MetaModel;

public class XpandJob
extends WorkspaceJob {
    protected static final Log log = LogFactory.getLog(XpandJob.class);
    protected List<MetaModel> metaModels;
    protected TypeSystem typeSystem = null;
    protected Collection<XpandEvaluationRequest> xpandEvaluationRequests;
    private IWorkspaceResourceLoader workspaceResourceLoader = null;
    private Collection<ExtendedOutlet> outlets;
    private ProtectedRegionResolverImpl protectedRegionResolver = null;

    public XpandJob(String name, MetaModel metaModel, XpandEvaluationRequest xpandEvaluationRequest) {
        this(name, Collections.singletonList(metaModel), Collections.singleton(xpandEvaluationRequest));
    }

    public XpandJob(String name, MetaModel metaModel, Collection<XpandEvaluationRequest> xpandEvaluationRequests) {
        this(name, Collections.singletonList(metaModel), xpandEvaluationRequests);
    }

    public XpandJob(String name, List<MetaModel> metaModels, XpandEvaluationRequest xpandEvaluationRequest) {
        this(name, metaModels, Collections.singleton(xpandEvaluationRequest));
    }

    public XpandJob(String name, List<MetaModel> metaModels, Collection<XpandEvaluationRequest> xpandEvaluationRequests) {
        super(name);
        Assert.isNotNull(metaModels);
        Assert.isNotNull(xpandEvaluationRequests);
        this.metaModels = metaModels;
        this.xpandEvaluationRequests = xpandEvaluationRequests;
    }

    public XpandJob(String name, TypeSystem typeSystem, XpandEvaluationRequest xpandEvaluationRequest) {
        this(name, typeSystem, Collections.singleton(xpandEvaluationRequest));
    }

    public XpandJob(String name, TypeSystem typeSystem, Collection<XpandEvaluationRequest> xpandEvaluationRequests) {
        super(name);
        Assert.isNotNull((Object)typeSystem);
        Assert.isNotNull(xpandEvaluationRequests);
        this.typeSystem = typeSystem;
        this.xpandEvaluationRequests = xpandEvaluationRequests;
    }

    protected Map<TransactionalEditingDomain, Collection<XpandEvaluationRequest>> getXpandEvaluationRequests() {
        HashMap<TransactionalEditingDomain, Collection<XpandEvaluationRequest>> requests = new HashMap<TransactionalEditingDomain, Collection<XpandEvaluationRequest>>();
        for (XpandEvaluationRequest request : this.xpandEvaluationRequests) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)request.getTargetObject());
            HashSet<XpandEvaluationRequest> requestsInEditingDomain = (HashSet<XpandEvaluationRequest>)requests.get(editingDomain);
            if (requestsInEditingDomain == null) {
                requestsInEditingDomain = new HashSet<XpandEvaluationRequest>();
                requests.put(editingDomain, requestsInEditingDomain);
            }
            requestsInEditingDomain.add(request);
        }
        return requests;
    }

    public void setWorkspaceResourceLoader(IWorkspaceResourceLoader resourceLoader) {
        this.workspaceResourceLoader = resourceLoader;
    }

    public Collection<ExtendedOutlet> getOutlets() {
        if (this.outlets == null) {
            this.outlets = new ArrayList<ExtendedOutlet>();
        }
        return this.outlets;
    }

    public void configureProtectedRegionResolver(String prSrcPaths, boolean prDefaultExcludes, String prExcludes) {
        if (prSrcPaths.trim().length() > 0) {
            if (this.protectedRegionResolver == null) {
                this.protectedRegionResolver = this.createProtectedRegionResolver();
            }
            this.protectedRegionResolver.setSrcPathes(prSrcPaths);
            this.protectedRegionResolver.setIgnoreList(prExcludes);
            this.protectedRegionResolver.setDefaultExcludes(prDefaultExcludes);
        }
    }

    protected ProtectedRegionResolverImpl createProtectedRegionResolver() {
        return new ProtectedRegionResolverImpl();
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            if (this.xpandEvaluationRequests.isEmpty()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            log.info((Object)"Generating code started...");
            this.installResourceLoader();
            OutputImpl output = new OutputImpl();
            if (!this.containsDefaultOutlet(this.getOutlets())) {
                this.getOutlets().add(this.createDefaultOutlet());
            }
            for (ExtendedOutlet outlet : this.getOutlets()) {
                outlet.setOverwrite(true);
                output.addOutlet((Outlet)outlet);
            }
            ResourceManagerDefaultImpl resourceManager = new ResourceManagerDefaultImpl();
            HashMap globalVarsMap = new HashMap();
            XpandExecutionContextImpl execCtx = new XpandExecutionContextImpl((ResourceManager)resourceManager, (Output)output, (ProtectedRegionResolver)this.protectedRegionResolver, globalVarsMap, (ProgressMonitor)new ProgressMonitorAdapter(monitor), null, null, null);
            if (this.metaModels != null) {
                for (MetaModel metaModel : this.metaModels) {
                    execCtx.registerMetaModel(metaModel);
                }
            }
            if (this.typeSystem instanceof TypeSystemImpl) {
                for (MetaModel metaModel : ((TypeSystemImpl)this.typeSystem).getMetaModels()) {
                    execCtx.registerMetaModel(metaModel);
                }
            }
            long startTime = System.currentTimeMillis();
            XpandFacade facade = XpandFacade.create((XpandExecutionContext)execCtx);
            final Map<TransactionalEditingDomain, Collection<XpandEvaluationRequest>> requests = this.getXpandEvaluationRequests();
            for (final TransactionalEditingDomain editingDomain : requests.keySet()) {
                Runnable runnable = new Runnable((ResourceManager)resourceManager, facade){
                    private final /* synthetic */ ResourceManager val$resourceManager;
                    private final /* synthetic */ XpandFacade val$facade;
                    {
                        this.val$resourceManager = resourceManager;
                        this.val$facade = xpandFacade;
                    }

                    @Override
                    public void run() {
                        for (XpandEvaluationRequest request : (Collection)requests.get(editingDomain)) {
                            log.info((Object)("Generating code for " + request.getTargetObject() + " with '" + request.getDefinitionName()));
                            XpandJob.this.updateResourceLoaderContext(request.getTargetObject());
                            IFile definitionFile = XtendXpandUtil.getUnderlyingFile(request.getDefinitionName(), "xpt", (ResourceLoader)XpandJob.this.workspaceResourceLoader);
                            if (definitionFile != null) {
                                try {
                                    this.val$resourceManager.setFileEncoding(definitionFile.getCharset());
                                }
                                catch (CoreException coreException) {
                                    // empty catch block
                                }
                            }
                            this.val$facade.evaluate(request.getDefinitionName(), request.getTargetObject(), request.getParameterList().toArray());
                        }
                    }
                };
                if (editingDomain != null) {
                    editingDomain.runExclusive(runnable);
                    continue;
                }
                runnable.run();
            }
            long duration = System.currentTimeMillis() - startTime;
            for (ExtendedOutlet outlet : this.getOutlets()) {
                String outletLabel = String.valueOf(outlet.getName() == null ? "[default]" : outlet.getName()) + "(" + outlet.getPath() + ")";
                if (outlet.getFilesWrittenAndClosed() > 0) {
                    log.info((Object)("Written " + outlet.getFilesWrittenAndClosed() + " files to outlet " + outletLabel));
                }
                if (outlet.getFilesCreated() <= outlet.getFilesWrittenAndClosed()) continue;
                log.info((Object)("Skipped writing of " + (outlet.getFilesCreated() - outlet.getFilesWrittenAndClosed()) + " files to outlet " + outletLabel));
            }
            log.info((Object)("Generation completed in " + duration + "ms!"));
            for (ExtendedOutlet outlet : this.getOutlets()) {
                IContainer container = outlet.getContainer();
                if (container == null) continue;
                container.refreshLocal(2, null);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OperationCanceledException exception) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception ex) {
            IStatus iStatus = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            return iStatus;
        }
        finally {
            this.uninstallResourceLoader();
        }
    }

    protected void installResourceLoader() {
        if (this.workspaceResourceLoader == null) {
            if (ResourceLoaderFactory.getCurrentThreadResourceLoader() instanceof IWorkspaceResourceLoader) {
                this.workspaceResourceLoader = (IWorkspaceResourceLoader)ResourceLoaderFactory.getCurrentThreadResourceLoader();
            }
        } else {
            ResourceLoaderFactory.setCurrentThreadResourceLoader((ResourceLoader)this.workspaceResourceLoader);
        }
    }

    protected void updateResourceLoaderContext(Object contextObject) {
        IFile contextFile;
        IModelDescriptor contextModel;
        if (this.workspaceResourceLoader != null && (contextModel = ModelDescriptorRegistry.INSTANCE.getModel(contextFile = EcorePlatformUtil.getFile((Object)contextObject))) != null) {
            this.workspaceResourceLoader.setContextModel(contextModel);
        }
    }

    protected void uninstallResourceLoader() {
        ResourceLoaderFactory.setCurrentThreadResourceLoader(null);
    }

    protected boolean containsDefaultOutlet(Collection<? extends Outlet> outlets) {
        for (Outlet outlet : outlets) {
            if (outlet.getName() != null) continue;
            return true;
        }
        return false;
    }

    protected ExtendedOutlet createDefaultOutlet() {
        return new ExtendedOutlet();
    }

    public boolean belongsTo(Object family) {
        return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
    }
}

