/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.referentialintegrity;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.domain.factory.AbstractResourceSetListenerInstaller;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeDetectorDelegate;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeListener;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeDetectorDelegateRegistry;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeEvent;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeListenerRegistry;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeNotification;
import org.eclipse.sphinx.platform.resources.DefaultResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.IResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.ResourceDeltaVisitor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class URIChangeDetector
extends ResourceSetListenerImpl
implements IResourceChangeListener {
    public void setTarget(TransactionalEditingDomain domain) {
        super.setTarget(domain);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void unsetTarget(TransactionalEditingDomain domain) {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.unsetTarget(domain);
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        List notifications = event.getNotifications();
        for (Object o : notifications) {
            List<URIChangeNotification> uriNotifications;
            EObject newEObject;
            Resource resource;
            IURIChangeDetectorDelegate delegate;
            Notification notification;
            if (!(o instanceof Notification) || !((notification = (Notification)o).getNotifier() instanceof EObject) || (delegate = URIChangeDetectorDelegateRegistry.INSTANCE.getDetectorDelegate(resource = (newEObject = (EObject)notification.getNotifier()).eResource())) == null || (uriNotifications = delegate.detectChangedURIs(notification)).isEmpty()) continue;
            this.fireURIChanged(this.createURIChangeEvent(resource, uriNotifications));
        }
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(event.getType(), (IResourceChangeHandler)new DefaultResourceChangeHandler(){

                    public void handleFileMoved(int eventType, IFile oldFile, IFile newFile) {
                        List<URIChangeNotification> notifications;
                        IURIChangeDetectorDelegate delegate;
                        Resource resource;
                        if (eventType == 1 && (resource = EcorePlatformUtil.getResource((IFile)oldFile)) != null && (delegate = URIChangeDetectorDelegateRegistry.INSTANCE.getDetectorDelegate(resource)) != null && !(notifications = delegate.detectChangedURIs(oldFile, newFile)).isEmpty()) {
                            URIChangeDetector.this.fireURIChanged(URIChangeDetector.this.createURIChangeEvent(resource, notifications));
                        }
                    }
                });
                delta.accept((IResourceDeltaVisitor)visitor);
            }
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
        }
    }

    protected URIChangeEvent createURIChangeEvent(Resource source, List<URIChangeNotification> notifications) {
        if (source != null && notifications != null && notifications.isEmpty()) {
            return null;
        }
        return new URIChangeEvent(source, notifications);
    }

    private void fireURIChanged(URIChangeEvent event) {
        if (event != null) {
            for (IURIChangeListener listener : URIChangeListenerRegistry.INSTANCE.getListeners()) {
                listener.uriChanged(event);
            }
        }
    }

    public static class URIChangeDetectorInstaller
    extends AbstractResourceSetListenerInstaller<URIChangeDetector> {
        public URIChangeDetectorInstaller() {
            super(URIChangeDetector.class);
        }
    }
}

