/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.jobs;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.sphinx.platform.internal.Activator;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class WorkspaceOperationWorkspaceJob
extends WorkspaceJob {
    protected IWorkspaceOperation operation;

    public WorkspaceOperationWorkspaceJob(IWorkspaceOperation operation) {
        super(operation.getLabel());
        Assert.isNotNull((Object)operation);
        this.operation = operation;
        this.setRule(operation.getRule());
        this.setPriority(40);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            this.operation.run(monitor);
        }
        catch (OperationCanceledException exception) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus(Activator.getDefault(), (Object)ex);
        }
        return Status.OK_STATUS;
    }
}

