/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.platform.resources.DefaultResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.IResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.ResourceDeltaVisitor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceWorkspaceChangeListener
implements IResourceChangeListener {
    protected Set<IFile> changedFiles = new HashSet<IFile>();
    protected Set<IFile> addedFiles = new HashSet<IFile>();
    protected Set<IProject> renamedProjects = new HashSet<IProject>();
    protected Set<IProject> projectsWithChangedDescription = new HashSet<IProject>();
    protected Map<IProject, Collection<String>> projectsWithChangedSettings = new HashMap<IProject, Collection<String>>();

    protected void finalize() throws Throwable {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.finalize();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(event.getType(), (IResourceChangeHandler)new DefaultResourceChangeHandler(){

                    public void handleProjectDescriptionChanged(int eventType, IProject project) {
                        ReferenceWorkspaceChangeListener.this.projectsWithChangedDescription.add(project);
                    }

                    public void handleProjectSettingsChanged(int eventType, IProject project, Collection<String> preferenceFileNames) {
                        if (ReferenceWorkspaceChangeListener.this.projectsWithChangedSettings.containsKey(project)) {
                            ReferenceWorkspaceChangeListener.this.projectsWithChangedSettings.get(project).addAll(preferenceFileNames);
                        } else {
                            ReferenceWorkspaceChangeListener.this.projectsWithChangedSettings.put(project, preferenceFileNames);
                        }
                    }

                    public void handleFileAdded(int eventType, IFile file) {
                        ReferenceWorkspaceChangeListener.this.addedFiles.add(file);
                    }

                    public void handleProjectOpened(int eventType, IProject project) {
                    }

                    public void handleFileChanged(int eventType, IFile file) {
                        ReferenceWorkspaceChangeListener.this.changedFiles.add(file);
                    }

                    public void handleProjectRenamed(int eventType, IProject oldProject, IProject newProject) {
                        ReferenceWorkspaceChangeListener.this.renamedProjects.add(newProject);
                    }

                    public void handleFileMoved(int eventType, IFile oldFile, IFile newFile) {
                        ReferenceWorkspaceChangeListener.this.addedFiles.add(newFile);
                    }
                });
                delta.accept((IResourceDeltaVisitor)visitor);
            }
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
        }
    }

    public Collection<IFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Collection<IFile> getAddedFiles() {
        return this.addedFiles;
    }

    public Collection<IProject> getRenamedProjects() {
        return this.renamedProjects;
    }

    public Collection<IProject> getProjectsWithChangedDescription() {
        return this.projectsWithChangedDescription;
    }

    public Map<IProject, Collection<String>> getProjectsWithChangedSettings() {
        return this.projectsWithChangedSettings;
    }

    public void clearHistory() {
        this.changedFiles.clear();
        this.addedFiles.clear();
        this.renamedProjects.clear();
        this.projectsWithChangedDescription.clear();
        this.projectsWithChangedSettings.clear();
    }
}

