/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.emf.check.catalog.Category;
import org.eclipse.sphinx.emf.check.operations.BasicCheckValidationOperation;
import org.eclipse.sphinx.emf.check.ui.dialogs.CategorySelectionContentProvider;
import org.eclipse.sphinx.emf.check.ui.dialogs.CategorySelectionDialog;
import org.eclipse.sphinx.emf.check.ui.dialogs.CategorySelectionLabelProvider;
import org.eclipse.sphinx.emf.check.ui.internal.Activator;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.IWrapper;
import org.eclipse.sphinx.platform.jobs.WorkspaceOperationWorkspaceJob;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.ui.operations.RunnableWithProgressAdapter;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicCheckValidationAction
extends BaseSelectionListenerAction {
    private boolean runInBackground;

    public BasicCheckValidationAction() {
        this("Check-based Validation");
        this.setRunInBackground(false);
    }

    public boolean isRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    protected BasicCheckValidationAction(String text) {
        super(text);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/check.png"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        return this.existsValidator();
    }

    protected boolean existsValidator() {
        List<Object> modelObjects = this.getModelObjects();
        for (Object modelObject : modelObjects) {
            EPackage ePackage;
            EValidator validator;
            if (!(modelObject instanceof EObject) || (validator = CheckValidatorRegistry.INSTANCE.getValidator(ePackage = ((EObject)modelObject).eClass().getEPackage())) != null) continue;
            return false;
        }
        return !modelObjects.isEmpty();
    }

    protected List<Object> getModelObjects() {
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        if (structuredSelection != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object selected : structuredSelection.toList()) {
                objects.addAll(this.getModelObjects(selected));
            }
            return objects;
        }
        return Collections.emptyList();
    }

    protected List<Object> getModelObjects(Object object) {
        Object target;
        if ((object = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof EObject) {
            return Collections.singletonList(object);
        }
        if (object instanceof IWrapper && (target = ((IWrapper)object).getTarget()) instanceof EObject) {
            return Collections.singletonList(target);
        }
        if (object instanceof TransientItemProvider) {
            TransientItemProvider provider = (TransientItemProvider)object;
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object child : provider.getChildren(object)) {
                objects.addAll(this.getModelObjects(child));
            }
            return objects;
        }
        Resource resource = null;
        if (object instanceof IFile) {
            resource = EcorePlatformUtil.getResource((IFile)((IFile)object));
        }
        if (object instanceof Resource) {
            resource = (Resource)object;
        }
        if (resource != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.addAll((Collection<Object>)resource.getContents());
            return objects;
        }
        return Collections.emptyList();
    }

    public void run() {
        Set<String> categories = this.promptForCheckCategories();
        if (categories == null) {
            return;
        }
        List<Object> modelObjects = this.getModelObjects();
        BasicCheckValidationOperation operation = this.createCheckValidationOperation(modelObjects, categories);
        if (this.isRunInBackground()) {
            WorkspaceOperationWorkspaceJob job = this.createWorkspaceOperationJob(operation);
            job.schedule();
        } else {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(ExtendedPlatformUI.getActiveShell());
                dialog.run(true, true, (IRunnableWithProgress)new RunnableWithProgressAdapter((IWorkspaceOperation)operation));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
    }

    protected WorkspaceOperationWorkspaceJob createWorkspaceOperationJob(BasicCheckValidationOperation operation) {
        return new WorkspaceOperationWorkspaceJob((IWorkspaceOperation)operation);
    }

    protected BasicCheckValidationOperation createCheckValidationOperation(List<Object> modelObjects, Set<String> categories) {
        return new BasicCheckValidationOperation(modelObjects, categories);
    }

    private Set<String> promptForCheckCategories() {
        HashSet<String> selectedCategories = new HashSet<String>();
        IStructuredContentProvider contentProvider = this.createContentProvider();
        ILabelProvider labelProvider = this.createLabelProvider();
        CategorySelectionDialog dialog = new CategorySelectionDialog(ExtendedPlatformUI.getActiveShell(), new Object(), contentProvider, labelProvider, "Select constraint categories");
        dialog.setTitle("Constraint categories selection");
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object resultObject = objectArray[n2];
                if (resultObject instanceof Category) {
                    selectedCategories.add(((Category)resultObject).getId());
                }
                ++n2;
            }
            return selectedCategories;
        }
        return null;
    }

    protected ILabelProvider createLabelProvider() {
        return new CategorySelectionLabelProvider();
    }

    protected IStructuredContentProvider createContentProvider() {
        return new CategorySelectionContentProvider();
    }
}

