/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.internal.saving;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;

public class CloseWorkbenchListener
implements IWorkbenchListener {
    public void postShutdown(IWorkbench workbench) {
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        final boolean[] canceled = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(Messages.error_failedToSaveModelsDuringWorkbenchClosing){

                    public void run() {
                        IWorkbenchWindow[] windows;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            canceled[0] = !PlatformUI.getWorkbench().saveAll((IShellProvider)window, (IRunnableContext)window, (ISaveableFilter)new AllSaveablesFilter(), true);
                        }
                    }
                });
            }
        });
        if (canceled[0]) {
            return false;
        }
        for (IModelDescriptor modelDescriptor : ModelDescriptorRegistry.INSTANCE.getAllModels()) {
            SaveIndicatorUtil.setSaved((IModelDescriptor)modelDescriptor);
        }
        return true;
    }

    private class AllSaveablesFilter
    implements ISaveableFilter {
        private AllSaveablesFilter() {
        }

        public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
            return saveable.isDirty();
        }
    }
}

